/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.constants;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DataCiteDateConstants {
    public static final String ISO_8601_TIME_WITHOUT_SECONDS = "(T\\d\\d:\\d\\d)([Z+])";
    public static final String ISO_8601_REPLACE_TIME_WITH_SECONDS = "$1:00$2";
    public static final String PARSE_ERROR = "Could not parse date string '%s'!";
    public static final String DATE_RANGE_SPLITTER = "/";
    public static final String VALUE_JSON = "value";
    public static final String DATE_TYPE_JSON = "dateType";
    public static final String DATE_INFO_JSON = "dateInformation";
    public static final String WORD_BEFORE_NUMBER_REGEX = "^\\D+\\s([^0-9]+[,.-]?\\s?\\d[\\d\\D]+)$";
    public static final String FIRST_NUMBER_REGEX = "^\\D+(\\d[\\d\\D]+)$";
    public static final String FIRST_MATCH = "$1";
    public static final String STANDARD_TIMEZONE = "UTC";
    public static final List<SimpleDateFormat> DATE_FORMATS_STARTING_WITH_CHAR = DataCiteDateConstants.createDateFormatsStartingWithChar((String)"UTC");
    public static final List<SimpleDateFormat> DATE_FORMATS_STARTING_WITH_NUM = DataCiteDateConstants.createDateFormatsStartingWithDigit((String)"UTC");

    private static List<SimpleDateFormat> createDateFormatsStartingWithDigit(String timeZoneName) {
        List<SimpleDateFormat> dateFormats = Collections.unmodifiableList(Arrays.asList(new SimpleDateFormat("dd.MM.yyyy", Locale.ENGLISH), new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH), new SimpleDateFormat("dd-MM-yyyy", Locale.ENGLISH), new SimpleDateFormat("dd MM yyyy", Locale.ENGLISH), new SimpleDateFormat("MM.yyyy", Locale.ENGLISH), new SimpleDateFormat("MM/yyyy", Locale.ENGLISH), new SimpleDateFormat("MM-yyyy", Locale.ENGLISH), new SimpleDateFormat("MM yyyy", Locale.ENGLISH), new SimpleDateFormat("d. MMMM, yyyy", Locale.ENGLISH), new SimpleDateFormat("d. MMMM yyyy", Locale.ENGLISH), new SimpleDateFormat("d MMMM, yyyy", Locale.ENGLISH), new SimpleDateFormat("d MMMM yyyy", Locale.ENGLISH), new SimpleDateFormat("dd-MMMM-yyyy", Locale.ENGLISH), new SimpleDateFormat("d-MMMM-yyyy", Locale.ENGLISH), new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH), new SimpleDateFormat("d-MMM-yyyy", Locale.ENGLISH), new SimpleDateFormat("dd. MMM. yyyy", Locale.ENGLISH), new SimpleDateFormat("dd. MMM, yyyy", Locale.ENGLISH), new SimpleDateFormat("dd. MMM yyyy", Locale.ENGLISH), new SimpleDateFormat("dd MMM. yyyy", Locale.ENGLISH), new SimpleDateFormat("dd MMM, yyyy", Locale.ENGLISH), new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH), new SimpleDateFormat("yyyy", Locale.ENGLISH)));
        dateFormats.forEach(sdf -> sdf.setTimeZone(TimeZone.getTimeZone(timeZoneName)));
        return dateFormats;
    }

    private static List<SimpleDateFormat> createDateFormatsStartingWithChar(String timeZoneName) {
        List<SimpleDateFormat> dateFormats = Collections.unmodifiableList(Arrays.asList(new SimpleDateFormat("MMMM, yyyy", Locale.ENGLISH), new SimpleDateFormat("MMMM yyyy", Locale.ENGLISH), new SimpleDateFormat("MMMM-yyyy", Locale.ENGLISH), new SimpleDateFormat("MMM yyyy", Locale.ENGLISH), new SimpleDateFormat("MMM, yyyy", Locale.ENGLISH), new SimpleDateFormat("MMM. yyyy", Locale.ENGLISH), new SimpleDateFormat("MMM-yyyy", Locale.ENGLISH)));
        dateFormats.forEach(sdf -> sdf.setTimeZone(TimeZone.getTimeZone(timeZoneName)));
        return dateFormats;
    }

    private DataCiteDateConstants() {
    }
}

