/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite.abstr;

import de.gerdiproject.harvest.utils.StringCleaner;
import de.gerdiproject.json.datacite.constants.DataCiteDateConstants;
import de.gerdiproject.json.datacite.enums.DateType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDate {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDate.class);
    private DateType dateType;
    private String dateInformation;

    public AbstractDate(DateType type) {
        this.dateType = type;
    }

    public abstract String getValue();

    public abstract void setValue(String var1);

    public DateType getType() {
        return this.dateType;
    }

    public void setType(DateType type) {
        this.dateType = type;
    }

    public String getDateInformation() {
        return this.dateInformation;
    }

    public void setDateInformation(String dateInformation) {
        this.dateInformation = dateInformation;
    }

    protected static Instant stringToInstant(String stringValue) {
        if (stringValue == null || stringValue.isEmpty()) {
            return null;
        }
        String cleanString = StringCleaner.clean((String)stringValue.replaceAll("(T\\d\\d:\\d\\d)([Z+])", "$1:00$2"));
        if (!Character.isDigit(cleanString.charAt(0))) {
            cleanString = cleanString.replaceAll("^\\D+\\s([^0-9]+[,.-]?\\s?\\d[\\d\\D]+)$", "$1");
            for (SimpleDateFormat format : DataCiteDateConstants.DATE_FORMATS_STARTING_WITH_CHAR) {
                try {
                    return format.parse(cleanString).toInstant();
                }
                catch (ParseException parseException) {
                }
            }
            cleanString = cleanString.replaceAll("^\\D+(\\d[\\d\\D]+)$", "$1");
        }
        if (Character.isDigit(cleanString.charAt(0))) {
            try {
                Calendar parsedCalendar = DatatypeConverter.parseDateTime((String)cleanString);
                parsedCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                return parsedCalendar.toInstant();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (SimpleDateFormat format : DataCiteDateConstants.DATE_FORMATS_STARTING_WITH_NUM) {
                    try {
                        return format.parse(cleanString).toInstant();
                    }
                    catch (ParseException parseException) {
                    }
                }
            }
        }
        LOGGER.warn(String.format("Could not parse date string '%s'!", stringValue));
        return null;
    }

    protected static Instant unixTimestampToInstant(long epochMilli) {
        return Instant.ofEpochMilli(epochMilli);
    }
}

