/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import com.google.gson.annotations.SerializedName;
import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.json.geo.GeoJson;
import de.gerdiproject.json.geo.IGeoCoordinates;
import de.gerdiproject.json.geo.Point;
import de.gerdiproject.json.geo.Polygon;
import java.util.Arrays;
import java.util.List;

public class GeoLocation
implements ICleanable {
    private String geoLocationPlace;
    private GeoJson geoLocationPoint;
    private GeoJson geoLocationBox;
    @SerializedName(value="geoLocationPolygon")
    private List<GeoJson> geoLocationPolygons;

    public String getPlace() {
        return this.geoLocationPlace;
    }

    public void setPlace(String place) {
        this.geoLocationPlace = place;
    }

    public GeoJson getPoint() {
        return this.geoLocationPoint;
    }

    public void setPoint(GeoJson point) {
        this.geoLocationPoint = point;
    }

    public List<GeoJson> getPolygons() {
        return this.geoLocationPolygons;
    }

    public void setPolygons(List<GeoJson> polygons) {
        this.geoLocationPolygons = polygons;
    }

    public GeoJson getBox() {
        return this.geoLocationBox;
    }

    public void setBox(double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        List<Point> boxShape = Arrays.asList(new Point(westBoundLongitude, northBoundLatitude), new Point(eastBoundLongitude, northBoundLatitude), new Point(eastBoundLongitude, southBoundLatitude), new Point(westBoundLongitude, southBoundLatitude), new Point(westBoundLongitude, northBoundLatitude));
        this.geoLocationBox = new GeoJson((IGeoCoordinates)new Polygon(boxShape));
    }

    public void clean() {
        if (this.geoLocationPoint != null) {
            this.geoLocationPoint.clean();
            if (!this.geoLocationPoint.isValid()) {
                this.geoLocationPoint = null;
            }
        }
        if (this.geoLocationPolygons != null) {
            int i = this.geoLocationPolygons.size();
            while (i != 0) {
                GeoJson geo;
                if ((geo = (GeoJson)this.geoLocationPolygons.get(--i)) == null) {
                    this.geoLocationPolygons.remove(i);
                    continue;
                }
                geo.clean();
                if (geo.isValid()) continue;
                this.geoLocationPolygons.remove(i);
            }
            if (this.geoLocationPolygons.isEmpty()) {
                this.geoLocationPolygons = null;
            }
        }
        if (this.geoLocationBox != null) {
            this.geoLocationBox.clean();
            if (!this.geoLocationBox.isValid()) {
                this.geoLocationBox = null;
            }
        }
    }

    public boolean isValid() {
        return this.geoLocationBox != null || this.geoLocationPolygons != null && !this.geoLocationPolygons.isEmpty() || this.geoLocationPoint != null;
    }
}

