/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.enums.DateType;
import java.time.Instant;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateRange
extends AbstractDate {
    private Instant since;
    private Instant until;

    public DateRange(String dateString, DateType type) {
        super(type);
        this.setValue(dateString);
    }

    public DateRange(long epochMilliSince, long epochMilliUntil, DateType type) {
        super(type);
        this.setRangeFrom(epochMilliSince);
        this.setRangeUntil(epochMilliUntil);
    }

    public DateRange(String rangeFrom, String rangeUntil, DateType type) {
        super(type);
        this.setRangeFrom(rangeFrom);
        this.setRangeUntil(rangeUntil);
    }

    public String getValue() {
        String sinceVal = "";
        String untilVal = "";
        if (this.since != null) {
            sinceVal = this.since.toString();
        }
        if (this.until != null) {
            untilVal = this.until.toString();
        }
        return sinceVal + "/" + untilVal;
    }

    public void setValue(String stringValue) {
        String[] range = stringValue.split("/");
        if (range.length == 2) {
            this.setRangeFrom(range[0]);
            this.setRangeUntil(range[1]);
        } else if (range.length == 1) {
            this.setRangeFrom(range[0]);
        } else {
            LOGGER.error(String.format("Could not parse date string '%s'!", stringValue));
        }
    }

    public void setRangeFrom(long epochMilli) {
        this.since = DateRange.unixTimestampToInstant((long)epochMilli);
    }

    public void setRangeFrom(String stringValue) {
        this.since = DateRange.stringToInstant((String)stringValue);
    }

    public void setRangeUntil(long epochMilli) {
        this.until = DateRange.unixTimestampToInstant((long)epochMilli);
    }

    public void setRangeUntil(String stringValue) {
        this.until = DateRange.stringToInstant((String)stringValue);
    }
}

