/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json.datacite;

import de.gerdiproject.harvest.ICleanable;
import de.gerdiproject.harvest.IDocument;
import de.gerdiproject.json.GsonUtils;
import de.gerdiproject.json.datacite.AlternateIdentifier;
import de.gerdiproject.json.datacite.Contributor;
import de.gerdiproject.json.datacite.Creator;
import de.gerdiproject.json.datacite.Description;
import de.gerdiproject.json.datacite.FundingReference;
import de.gerdiproject.json.datacite.GeoLocation;
import de.gerdiproject.json.datacite.Identifier;
import de.gerdiproject.json.datacite.RelatedIdentifier;
import de.gerdiproject.json.datacite.ResourceType;
import de.gerdiproject.json.datacite.Rights;
import de.gerdiproject.json.datacite.Subject;
import de.gerdiproject.json.datacite.Title;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.extension.ResearchData;
import de.gerdiproject.json.datacite.extension.WebLink;
import de.gerdiproject.json.datacite.extension.abstr.AbstractResearch;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCiteJson
implements IDocument,
ICleanable {
    private static final String ERROR_INVALID_GEO_LOCATION_LIST = "Could not remove invalid GeoLocations! The DataCiteJson.geoLocations list must support remove() operations!";
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCiteJson.class);
    private final transient String sourceId;
    private Identifier identifier;
    private List<Creator> creators;
    private List<Title> titles;
    private String publisher;
    private short publicationYear;
    private ResourceType resourceType;
    private List<Subject> subjects;
    private List<Contributor> contributors;
    private List<AbstractDate> dates;
    private String language;
    private List<AlternateIdentifier> alternateIdentifiers;
    private List<RelatedIdentifier> relatedIdentifiers;
    private List<String> sizes;
    private List<String> formats;
    private String version;
    private List<Rights> rightsList;
    private List<Description> descriptions;
    private List<GeoLocation> geoLocations;
    private List<FundingReference> fundingReferences;
    private List<WebLink> webLinks;
    private List<ResearchData> researchDataList;
    private String repositoryIdentifier;
    private List<AbstractResearch> researchDisciplines;

    public DataCiteJson(String sourceId) {
        this.sourceId = sourceId;
    }

    @Deprecated
    public DataCiteJson() {
        this.sourceId = null;
    }

    public String getSourceId() {
        if (this.sourceId == null) {
            return String.valueOf(GsonUtils.getGson().toJson((Object)this).hashCode());
        }
        return this.sourceId;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public short getPublicationYear() {
        return this.publicationYear;
    }

    public void setPublicationYear(short publicationYear) {
        this.publicationYear = publicationYear;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public String getRepositoryIdentifier() {
        return this.repositoryIdentifier;
    }

    public void setRepositoryIdentifier(String repositoryIdentifier) {
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public List<AbstractResearch> getResearchDisciplines() {
        return this.researchDisciplines;
    }

    public void setResearchDisciplines(List<AbstractResearch> researchDisciplines) {
        this.researchDisciplines = researchDisciplines;
    }

    public List<String> getSizes() {
        return this.sizes;
    }

    public void setSizes(List<String> sizes) {
        this.sizes = sizes;
    }

    public List<String> getFormats() {
        return this.formats;
    }

    public void setFormats(List<String> formats) {
        this.formats = formats;
    }

    public List<Creator> getCreators() {
        return this.creators;
    }

    public void setCreators(List<Creator> creators) {
        this.creators = creators;
    }

    public List<Title> getTitles() {
        return this.titles;
    }

    public void setTitles(List<Title> titles) {
        this.titles = titles;
    }

    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<Subject> subjects) {
        this.subjects = subjects;
    }

    public List<Contributor> getContributors() {
        return this.contributors;
    }

    public void setContributors(List<Contributor> contributors) {
        this.contributors = contributors;
    }

    public List<AbstractDate> getDates() {
        return this.dates;
    }

    public void setDates(List<AbstractDate> dates) {
        this.dates = dates;
    }

    public List<GeoLocation> getGeoLocations() {
        return this.geoLocations;
    }

    public void setGeoLocations(List<GeoLocation> geoLocations) {
        this.geoLocations = geoLocations;
    }

    public List<RelatedIdentifier> getRelatedIdentifiers() {
        return this.relatedIdentifiers;
    }

    public void setRelatedIdentifiers(List<RelatedIdentifier> relatedIdentifiers) {
        this.relatedIdentifiers = relatedIdentifiers;
    }

    public List<AlternateIdentifier> getAlternateIdentifiers() {
        return this.alternateIdentifiers;
    }

    public void setAlternateIdentifiers(List<AlternateIdentifier> alternateIdentifiers) {
        this.alternateIdentifiers = alternateIdentifiers;
    }

    public List<Rights> getRightsList() {
        return this.rightsList;
    }

    public void setRightsList(List<Rights> rightsList) {
        this.rightsList = rightsList;
    }

    public List<FundingReference> getFundingReferences() {
        return this.fundingReferences;
    }

    public void setFundingReferences(List<FundingReference> fundingReferences) {
        this.fundingReferences = fundingReferences;
    }

    public List<WebLink> getWebLinks() {
        return this.webLinks;
    }

    public void setWebLinks(List<WebLink> webLinks) {
        this.webLinks = webLinks;
    }

    public List<ResearchData> getResearchDataList() {
        return this.researchDataList;
    }

    public void setResearchDataList(List<ResearchData> files) {
        this.researchDataList = files;
    }

    public void clean() {
        int i;
        if (this.creators != null) {
            i = this.creators.size();
            while (i-- != 0) {
                if (this.creators.get(i) != null) continue;
                this.creators.remove(i);
            }
            if (this.creators.isEmpty()) {
                this.creators = null;
            }
        }
        if (this.titles != null) {
            i = this.titles.size();
            while (i-- != 0) {
                Title title = (Title)this.titles.get(i);
                if (title == null) {
                    this.titles.remove(i);
                    continue;
                }
                title.clean();
            }
            if (this.titles.isEmpty()) {
                this.titles = null;
            }
        }
        if (this.subjects != null) {
            i = this.subjects.size();
            while (i-- != 0) {
                Subject subject = (Subject)this.subjects.get(i);
                if (subject == null) {
                    this.subjects.remove(i);
                    continue;
                }
                subject.clean();
            }
            if (this.subjects.isEmpty()) {
                this.subjects = null;
            }
        }
        if (this.contributors != null) {
            i = this.contributors.size();
            while (i-- != 0) {
                if (this.contributors.get(i) != null) continue;
                this.contributors.remove(i);
            }
            if (this.contributors.isEmpty()) {
                this.contributors = null;
            }
        }
        if (this.alternateIdentifiers != null) {
            i = this.alternateIdentifiers.size();
            while (i-- != 0) {
                if (this.alternateIdentifiers.get(i) != null) continue;
                this.alternateIdentifiers.remove(i);
            }
            if (this.alternateIdentifiers.isEmpty()) {
                this.alternateIdentifiers = null;
            }
        }
        if (this.relatedIdentifiers != null) {
            i = this.relatedIdentifiers.size();
            while (i-- != 0) {
                if (this.relatedIdentifiers.get(i) != null) continue;
                this.relatedIdentifiers.remove(i);
            }
            if (this.relatedIdentifiers.isEmpty()) {
                this.relatedIdentifiers = null;
            }
        }
        if (this.sizes != null) {
            i = this.sizes.size();
            while (i-- != 0) {
                if (this.sizes.get(i) != null) continue;
                this.sizes.remove(i);
            }
            if (this.sizes.isEmpty()) {
                this.sizes = null;
            }
        }
        if (this.formats != null) {
            i = this.formats.size();
            while (i-- != 0) {
                if (this.formats.get(i) != null) continue;
                this.formats.remove(i);
            }
            if (this.formats.isEmpty()) {
                this.formats = null;
            }
        }
        if (this.rightsList != null) {
            i = this.rightsList.size();
            while (i-- != 0) {
                Rights rights = (Rights)this.rightsList.get(i);
                if (rights == null) {
                    this.rightsList.remove(i);
                    continue;
                }
                rights.clean();
            }
            if (this.rightsList.isEmpty()) {
                this.rightsList = null;
            }
        }
        if (this.descriptions != null) {
            i = this.descriptions.size();
            while (i-- != 0) {
                Description description = (Description)this.descriptions.get(i);
                if (description == null) {
                    this.descriptions.remove(i);
                    continue;
                }
                description.clean();
            }
            if (this.descriptions.isEmpty()) {
                this.descriptions = null;
            }
        }
        if (this.fundingReferences != null) {
            i = this.fundingReferences.size();
            while (i-- != 0) {
                if (this.fundingReferences.get(i) != null) continue;
                this.fundingReferences.remove(i);
            }
            if (this.fundingReferences.isEmpty()) {
                this.fundingReferences = null;
            }
        }
        if (this.webLinks != null) {
            i = this.webLinks.size();
            while (i-- != 0) {
                if (this.webLinks.get(i) != null) continue;
                this.webLinks.remove(i);
            }
            if (this.webLinks.isEmpty()) {
                this.webLinks = null;
            }
        }
        if (this.researchDataList != null) {
            i = this.researchDataList.size();
            while (i-- != 0) {
                if (this.researchDataList.get(i) != null) continue;
                this.researchDataList.remove(i);
            }
            if (this.researchDataList.isEmpty()) {
                this.researchDataList = null;
            }
        }
        if (this.researchDisciplines != null) {
            i = this.researchDisciplines.size();
            while (i-- != 0) {
                if (this.researchDisciplines.get(i) != null) continue;
                this.researchDisciplines.remove(i);
            }
            if (this.researchDisciplines.isEmpty()) {
                this.researchDisciplines = null;
            }
        }
        if (this.dates != null) {
            i = this.dates.size();
            while (i-- != 0) {
                AbstractDate d = (AbstractDate)this.dates.get(i);
                if (d != null && d.getValue() != null) continue;
                this.dates.remove(i);
            }
            if (this.dates.isEmpty()) {
                this.dates = null;
            }
        }
        if (this.geoLocations != null) {
            try {
                i = this.geoLocations.size();
                while (i != 0) {
                    GeoLocation geoLoc;
                    if ((geoLoc = (GeoLocation)this.geoLocations.get(--i)) == null) {
                        this.geoLocations.remove(i);
                        continue;
                    }
                    geoLoc.clean();
                    if (geoLoc.isValid()) continue;
                    this.geoLocations.remove(i);
                }
            }
            catch (UnsupportedOperationException e) {
                LOGGER.error(ERROR_INVALID_GEO_LOCATION_LIST);
            }
            if (this.geoLocations.isEmpty()) {
                this.geoLocations = null;
            }
        }
    }
}

