/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.gerdiproject.json.datacite.Date;
import de.gerdiproject.json.datacite.DateRange;
import de.gerdiproject.json.datacite.abstr.AbstractDate;
import de.gerdiproject.json.datacite.adapter.DateAdapter;
import de.gerdiproject.json.datacite.extension.ResearchArea;
import de.gerdiproject.json.datacite.extension.ResearchDiscipline;
import de.gerdiproject.json.datacite.extension.abstr.AbstractResearch;
import de.gerdiproject.json.datacite.extension.adapter.ResearchAdapter;
import de.gerdiproject.json.geo.GeoJson;
import de.gerdiproject.json.geo.LineString;
import de.gerdiproject.json.geo.MultiLineString;
import de.gerdiproject.json.geo.MultiPoint;
import de.gerdiproject.json.geo.MultiPolygon;
import de.gerdiproject.json.geo.Point;
import de.gerdiproject.json.geo.Polygon;
import de.gerdiproject.json.geo.adapter.GeoJsonAdapter;
import de.gerdiproject.json.geo.adapter.LineStringAdapter;
import de.gerdiproject.json.geo.adapter.MultiLineStringAdapter;
import de.gerdiproject.json.geo.adapter.MultiPointAdapter;
import de.gerdiproject.json.geo.adapter.MultiPolygonAdapter;
import de.gerdiproject.json.geo.adapter.PointAdapter;
import de.gerdiproject.json.geo.adapter.PolygonAdapter;

public final class GsonUtils {
    private static final String ERROR_NOT_INITIALIZED = "GsonUtils was not initialized!";
    private static Gson GSON;
    private static Gson PRETTY_GSON;

    public static void init(GsonBuilder builder) {
        builder.registerTypeAdapter(Point.class, (Object)new PointAdapter()).registerTypeAdapter(MultiPoint.class, (Object)new MultiPointAdapter()).registerTypeAdapter(LineString.class, (Object)new LineStringAdapter()).registerTypeAdapter(MultiLineString.class, (Object)new MultiLineStringAdapter()).registerTypeAdapter(Polygon.class, (Object)new PolygonAdapter()).registerTypeAdapter(MultiPolygon.class, (Object)new MultiPolygonAdapter()).registerTypeAdapter(GeoJson.class, (Object)new GeoJsonAdapter()).registerTypeAdapter(AbstractDate.class, (Object)new DateAdapter()).registerTypeAdapter(DateRange.class, (Object)new DateAdapter()).registerTypeAdapter(Date.class, (Object)new DateAdapter()).registerTypeAdapter(AbstractResearch.class, (Object)new ResearchAdapter()).registerTypeAdapter(ResearchArea.class, (Object)new ResearchAdapter()).registerTypeAdapter(ResearchDiscipline.class, (Object)new ResearchAdapter());
        GSON = builder.create();
        PRETTY_GSON = builder.setPrettyPrinting().create();
    }

    public static Gson getGson() {
        if (GSON == null) {
            throw new IllegalStateException(ERROR_NOT_INITIALIZED);
        }
        return GSON;
    }

    public static Gson getPrettyGson() {
        if (PRETTY_GSON == null) {
            throw new IllegalStateException(ERROR_NOT_INITIALIZED);
        }
        return PRETTY_GSON;
    }

    private GsonUtils() {
    }
}

