/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.harvest.utils;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringCleaner {
    private static final int MIN_ESCAPE = 2;
    private static final int MAX_ESCAPE = 6;
    private static final int DECIMAL_RADIX = 10;
    private static final int HEXADECIMAL_RADIX = 16;
    private static final int MAX_SINGLE_CHAR_VALUE = 65535;
    private static final Map<String, String> ESCAPE_LOOKUP_TABLE = StringCleaner.createEscapeMap();

    private static Map<String, String> createEscapeMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("quot", "\"");
        m.put("amp", "&");
        m.put("lt", "<");
        m.put("gt", ">");
        m.put("nbsp", "\u00a0");
        m.put("iexcl", "\u00a1");
        m.put("cent", "\u00a2");
        m.put("pound", "\u00a3");
        m.put("curren", "\u00a4");
        m.put("yen", "\u00a5");
        m.put("brvbar", "\u00a6");
        m.put("sect", "\u00a7");
        m.put("uml", "\u00a8");
        m.put("copy", "\u00a9");
        m.put("ordf", "\u00aa");
        m.put("laquo", "\u00ab");
        m.put("not", "\u00ac");
        m.put("shy", "\u00ad");
        m.put("reg", "\u00ae");
        m.put("macr", "\u00af");
        m.put("deg", "\u00b0");
        m.put("plusmn", "\u00b1");
        m.put("sup2", "\u00b2");
        m.put("sup3", "\u00b3");
        m.put("acute", "\u00b4");
        m.put("micro", "\u00b5");
        m.put("para", "\u00b6");
        m.put("middot", "\u00b7");
        m.put("cedil", "\u00b8");
        m.put("sup1", "\u00b9");
        m.put("ordm", "\u00ba");
        m.put("raquo", "\u00bb");
        m.put("frac14", "\u00bc");
        m.put("frac12", "\u00bd");
        m.put("frac34", "\u00be");
        m.put("iquest", "\u00bf");
        m.put("Agrave", "\u00c0");
        m.put("Aacute", "\u00c1");
        m.put("Acirc", "\u00c2");
        m.put("Atilde", "\u00c3");
        m.put("Auml", "\u00c4");
        m.put("Aring", "\u00c5");
        m.put("AElig", "\u00c6");
        m.put("Ccedil", "\u00c7");
        m.put("Egrave", "\u00c8");
        m.put("Eacute", "\u00c9");
        m.put("Ecirc", "\u00ca");
        m.put("Euml", "\u00cb");
        m.put("Igrave", "\u00cc");
        m.put("Iacute", "\u00cd");
        m.put("Icirc", "\u00ce");
        m.put("Iuml", "\u00cf");
        m.put("ETH", "\u00d0");
        m.put("Ntilde", "\u00d1");
        m.put("Ograve", "\u00d2");
        m.put("Oacute", "\u00d3");
        m.put("Ocirc", "\u00d4");
        m.put("Otilde", "\u00d5");
        m.put("Ouml", "\u00d6");
        m.put("times", "\u00d7");
        m.put("Oslash", "\u00d8");
        m.put("Ugrave", "\u00d9");
        m.put("Uacute", "\u00da");
        m.put("Ucirc", "\u00db");
        m.put("Uuml", "\u00dc");
        m.put("Yacute", "\u00dd");
        m.put("THORN", "\u00de");
        m.put("szlig", "\u00df");
        m.put("agrave", "\u00e0");
        m.put("aacute", "\u00e1");
        m.put("acirc", "\u00e2");
        m.put("atilde", "\u00e3");
        m.put("auml", "\u00e4");
        m.put("aring", "\u00e5");
        m.put("aelig", "\u00e6");
        m.put("ccedil", "\u00e7");
        m.put("egrave", "\u00e8");
        m.put("eacute", "\u00e9");
        m.put("ecirc", "\u00ea");
        m.put("euml", "\u00eb");
        m.put("igrave", "\u00ec");
        m.put("iacute", "\u00ed");
        m.put("icirc", "\u00ee");
        m.put("iuml", "\u00ef");
        m.put("eth", "\u00f0");
        m.put("ntilde", "\u00f1");
        m.put("ograve", "\u00f2");
        m.put("oacute", "\u00f3");
        m.put("ocirc", "\u00f4");
        m.put("otilde", "\u00f5");
        m.put("ouml", "\u00f6");
        m.put("divide", "\u00f7");
        m.put("oslash", "\u00f8");
        m.put("ugrave", "\u00f9");
        m.put("uacute", "\u00fa");
        m.put("ucirc", "\u00fb");
        m.put("uuml", "\u00fc");
        m.put("yacute", "\u00fd");
        m.put("thorn", "\u00fe");
        m.put("yuml", "\u00ff");
        return m;
    }

    public static String clean(String input) {
        if (input.indexOf(60) != -1) {
            input = Jsoup.parse((String)input).text();
        }
        input = StringCleaner.unescapeHtml((String)input);
        input = input.replaceAll("&nbsp;", " ");
        input = input.replaceAll("\u00a0", " ");
        input = input.replaceAll("[\\u00A0\\s]{2,}", " ");
        return input.trim();
    }

    public static final String unescapeHtml(String input) {
        StringWriter writer = null;
        int st = 0;
        int startIndex = 0;
        while ((startIndex = input.indexOf(38, startIndex) + 1) != 0) {
            int endIndex;
            block11: {
                endIndex = input.indexOf(59, startIndex);
                int len = endIndex - startIndex;
                if (endIndex == -1 || len < 2 || len > 6) {
                    ++startIndex;
                    continue;
                }
                if (input.charAt(startIndex) == '#') {
                    int numberStartIndex = startIndex + 1;
                    int radix = 10;
                    char firstChar = input.charAt(numberStartIndex);
                    if (firstChar == 'x' || firstChar == 'X') {
                        ++numberStartIndex;
                        radix = 16;
                    }
                    try {
                        int entityValue = Integer.parseUnsignedInt(input.substring(numberStartIndex, endIndex), radix);
                        if (writer == null) {
                            writer = new StringWriter(input.length());
                        }
                        writer.append(input.substring(st, startIndex - 1));
                        if (entityValue > 65535) {
                            char[] chrs = Character.toChars(entityValue);
                            writer.write(chrs[0]);
                            writer.write(chrs[1]);
                        } else {
                            writer.write(entityValue);
                        }
                        break block11;
                    }
                    catch (NumberFormatException ex) {
                        ++startIndex;
                        continue;
                    }
                }
                CharSequence value = (CharSequence)ESCAPE_LOOKUP_TABLE.get(input.substring(startIndex, endIndex));
                if (value == null) {
                    ++startIndex;
                    continue;
                }
                if (writer == null) {
                    writer = new StringWriter(input.length());
                }
                writer.append(input.substring(st, startIndex - 1));
                writer.append(value);
            }
            startIndex = st = endIndex + 1;
        }
        return writer == null ? input : writer.append(input.substring(st)).toString();
    }
}

