/*
 * Decompiled with CFR 0.152.
 */
package de.gerdiproject.generator.research.utils;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import de.gerdiproject.generator.research.constants.ResearchGeneratorConstants;
import de.gerdiproject.generator.research.source.json.ResearchAreaSource;
import de.gerdiproject.generator.research.source.json.ResearchCategorySource;
import de.gerdiproject.generator.research.source.json.ResearchDisciplineSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResearchGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResearchGenerator.class);

    public static void main(String[] args) {
        ResearchGenerator generator = new ResearchGenerator();
        if (args == null || args.length == 0) {
            generator.generateConstants(new String[]{"src/main/java/de/gerdiproject/generator/research/source/DfgTopics.json"});
        } else {
            generator.generateConstants(args);
        }
    }

    public void generateConstants(String ... filePaths) {
        LOGGER.info("Started generating ResearchDisciplineConstants.java, ResearchAreaConstants.java, and ResearchCategoryConstants.java");
        OutputStreamWriter categoryWriter = this.initConstantsFile("ResearchCategory", new String[0]);
        OutputStreamWriter areaWriter = this.initConstantsFile("ResearchArea", new String[]{"de.gerdiproject.json.datacite.extension.ResearchArea", "java.util.Map", "java.util.HashMap"});
        OutputStreamWriter disciplineWriter = this.initConstantsFile("ResearchDiscipline", new String[]{"de.gerdiproject.json.datacite.extension.ResearchDiscipline", "java.util.Map", "java.util.HashMap"});
        StringBuilder areaMapBuilder = new StringBuilder();
        StringBuilder disciplineMapBuilder = new StringBuilder();
        for (String filePath : filePaths) {
            try {
                this.addConstantsFromFile(filePath, categoryWriter, areaWriter, disciplineWriter, areaMapBuilder, disciplineMapBuilder);
            }
            catch (IOException e) {
                LOGGER.error(String.format("Could not read file '%s'!", filePath), (Throwable)e);
            }
        }
        try {
            categoryWriter.append(String.format("%n%n%n    /**%n     * Private constructor, because this is a static class.%n     */%n    private %sConstants()%n    {%n%n    }", "ResearchCategory"));
        }
        catch (IOException e) {
            LOGGER.error("Could not write to file!", (Throwable)e);
        }
        try {
            areaWriter.append(String.format("%n    // Convenience Map%n    private static final Map<Integer, %s> RESEARCH_MAP =%n        createResearchMap(%s%n        );", "ResearchArea", areaMapBuilder.toString()));
            areaWriter.append(String.format("%n%n%n    /**%n     * Private constructor, because this is a static class.%n     */%n    private %sConstants()%n    {%n%n    }", "ResearchArea"));
            areaWriter.append("\n\n\n    /**\n     * This function returns a {@linkplain ResearchArea} by parsing a string\n     * which contains the area RNBR.\n     *\n     * @param rnbrString the area RNBR as a string\n     *\n     * @return an area that matches the RNBR\n     */\n    public static ResearchArea getByRnbrString(String rnbrString)\n    {\n        int rnbr = Integer.parseInt(rnbrString);\n        return RESEARCH_MAP.get(rnbr);\n    }");
            areaWriter.append("\n\n\n    /**\n     * A convenience function for initializing the research map.\n     *\n     * @param areas a list of areas that are to be added to the map\n     *\n     * @return a hashmap that maps area RNBRs to research areas\n     */\n    private static Map<Integer, ResearchArea> createResearchMap(ResearchArea ...areas)\n    {\n        final Map<Integer, ResearchArea> map = new HashMap<>();\n\n        for (ResearchArea ra : areas)\n            map.put(ra.getRbnr(), ra);\n\n        return map;\n    }");
        }
        catch (IOException e) {
            LOGGER.error("Could not write to file!", (Throwable)e);
        }
        try {
            disciplineWriter.append(String.format("%n    // Convenience Map%n    private static final Map<Integer, %s> RESEARCH_MAP =%n        createResearchMap(%s%n        );", "Map<Integer, ResearchDiscipline>", disciplineMapBuilder.toString()));
            disciplineWriter.append(String.format("%n%n%n    /**%n     * Private constructor, because this is a static class.%n     */%n    private %sConstants()%n    {%n%n    }", "ResearchDiscipline"));
            disciplineWriter.append("\n\n\n    /**\n     * This function returns a {@linkplain ResearchDiscipline} by parsing a string\n     * which contains the area RNBR and the internal RNBR of the discipline.\n     *\n     * @param rnbrString a string of the format AREA_RNBR-DISCIPLINE_RNBR\n     *\n     * @return a discipline that has a matching RNBR\n     */\n    public static ResearchDiscipline getByRnbrString(String rnbrString)\n    {\n        String[] splitRnbr = rnbrString.split(\"-\");\n        int areaRnbr = Integer.parseInt(splitRnbr[0]);\n        int disciplineRnbr = Integer.parseInt(splitRnbr[1]);\n\n        Map<Integer, ResearchDiscipline> subClasses = RESEARCH_MAP.get(areaRnbr);\n\n        return (subClasses != null) ? subClasses.get(disciplineRnbr) : null;\n    }");
            disciplineWriter.append("\n\n\n    /**\n     * A convenience function for initializing the research map.\n     *\n     * @param disciplines a list of disciplines that are to be added to the map\n     *\n     * @return a hashmap that maps area RNBRs to hashmaps of discipline RNBRs and disciplines\n     */\n    private static Map<Integer, Map<Integer, ResearchDiscipline>> createResearchMap(ResearchDiscipline ...disciplines)\n    {\n        final Map<Integer, Map<Integer, ResearchDiscipline>> map = new HashMap<>();\n\n        for (ResearchDiscipline rd : disciplines) {\n            int categoryRnbr = rd.getArea().getRbnr();\n            map.putIfAbsent(categoryRnbr, new HashMap<>());\n            map.get(categoryRnbr).put(rd.getRbnr(), rd);\n        }\n\n        return map;\n    }");
        }
        catch (IOException e) {
            LOGGER.error("Could not write to file!", (Throwable)e);
        }
        this.finishConstantsFile(categoryWriter);
        this.finishConstantsFile(areaWriter);
        this.finishConstantsFile(disciplineWriter);
        LOGGER.info("Finished Generating");
    }

    private void addConstantsFromFile(String filePath, OutputStreamWriter categoryWriter, OutputStreamWriter areaWriter, OutputStreamWriter disciplineWriter, StringBuilder areaMapBuilder, StringBuilder disciplineMapBuilder) throws IOException {
        List categories = this.readResearchListFromFile(filePath);
        if (categories == null || categories.isEmpty()) {
            return;
        }
        for (ResearchCategorySource sCat : categories) {
            String categoryConstName = ResearchGenerator.getConstantName((String)sCat.getName());
            categoryWriter.append(String.format("%n    public static final String %s = \"%s\";", categoryConstName, sCat.getName()));
            areaWriter.append(String.format("%n    // %s", categoryConstName));
            for (ResearchAreaSource area : sCat.getSubclasses()) {
                String areaConstName = ResearchGenerator.getConstantName((String)area.getName());
                areaWriter.append(String.format("%n    public static final ResearchArea %s = new ResearchArea(%d, \"%s\", ResearchCategoryConstants.%s);", areaConstName, area.getRBNR(), area.getName(), categoryConstName));
                disciplineWriter.append(String.format("%n    // %s", areaConstName));
                if (areaMapBuilder.length() != 0) {
                    areaMapBuilder.append(',');
                }
                areaMapBuilder.append(String.format("%n            %s", areaConstName));
                for (ResearchDisciplineSource discipline : area.getSubclasses()) {
                    String disciConstName = ResearchGenerator.getConstantName((String)discipline.getName());
                    disciplineWriter.append(String.format("%n    public static final ResearchDiscipline %s = new ResearchDiscipline(%d, \"%s\", ResearchAreaConstants.%s);", disciConstName, discipline.getRBNR(), discipline.getName(), areaConstName));
                    if (disciplineMapBuilder.length() != 0) {
                        disciplineMapBuilder.append(',');
                    }
                    disciplineMapBuilder.append(String.format("%n            %s", disciConstName));
                }
                disciplineWriter.append('\n');
            }
            areaWriter.append('\n');
        }
    }

    private OutputStreamWriter initConstantsFile(String constantType, String ... imports) {
        String filePath = String.format("src/main/java/de/gerdiproject/json/datacite/extension/constants/%sConstants.java", constantType);
        File output = new File(filePath);
        boolean isDirectoryCreated = output.getParentFile().exists() || output.getParentFile().mkdirs();
        OutputStreamWriter writer = null;
        if (isDirectoryCreated) {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);
                StringBuilder importBuilder = new StringBuilder();
                for (String importClassName : imports) {
                    importBuilder.append(String.format("%nimport %s;", importClassName));
                }
                writer.append(String.format("/*%n *  Licensed to the Apache Software Foundation (ASF) under one%n *  or more contributor license agreements.  See the NOTICE file%n *  distributed with this work for additional information%n *  regarding copyright ownership.  The ASF licenses this file%n *  to you under the Apache License, Version 2.0 (the%n *  \"License\"); you may not use this file except in compliance%n *  with the License.  You may obtain a copy of the License at%n *%n *    http://www.apache.org/licenses/LICENSE-2.0%n *%n *  Unless required by applicable law or agreed to in writing,%n *  software distributed under the License is distributed on an%n *  \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY%n *  KIND, either express or implied.  See the License for the%n *  specific language governing permissions and limitations%n *  under the License.%n */%npackage de.gerdiproject.json.datacite.extension.constants;%n%nimport de.gerdiproject.generator.research.utils.ResearchGenerator;%2$s%n%n/**%n  * This static class is a collection of constants that define a controlled list of %1$ss.%n  * It was generated via the {@linkplain ResearchGenerator}.%n  * If there are errors or inconsistencies, please contact the authors.%n  *%n  * @author Fidan Limani, Robin Weiss%n  */%npublic class %1$sConstants%n{", constantType, importBuilder.toString()));
            }
            catch (IOException e) {
                LOGGER.error(String.format("Could not create file '%s'!", filePath), (Throwable)e);
            }
        } else {
            LOGGER.error(String.format("Could not create directories for file '%s'!", filePath));
        }
        return writer;
    }

    private void finishConstantsFile(OutputStreamWriter writer) {
        try {
            writer.append("\n}");
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not write to file!", (Throwable)e);
        }
    }

    private List<ResearchCategorySource> readResearchListFromFile(String filepath) throws IOException {
        List researchList = null;
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(filepath), StandardCharsets.UTF_8));
        researchList = (List)new Gson().fromJson(reader, listType);
        return researchList;
    }

    private static String getConstantName(String sourceName) {
        String constName = sourceName;
        for (String nameBreakingString : ResearchGeneratorConstants.NAME_BREAKING_STRINGS) {
            int breakIndex = constName.indexOf(nameBreakingString);
            if (breakIndex == -1) continue;
            constName = constName.substring(0, breakIndex);
        }
        constName = constName.replaceAll(ResearchGeneratorConstants.SEPARATOR_CHARS_PATTERN, " ");
        constName = constName.replaceAll(" +", "_");
        return constName.toUpperCase();
    }
}

