/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.zeta.sdk.network.http.client;

import de.gematik.zeta.logging.Log;
import de.gematik.zeta.sdk.network.http.client.ZetaHttpClient_jvmKt;
import de.gematik.zeta.sdk.network.http.client.config.ClientConfig;
import de.gematik.zeta.sdk.network.http.client.config.ClientConfigKt;
import io.github.aakira.napier.LogLevel;
import io.github.aakira.napier.Napier;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.plugins.DefaultRequest;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.HttpRequestRetryConfig;
import io.ktor.client.plugins.HttpRequestRetryKt;
import io.ktor.client.plugins.HttpRetryShouldRetryContext;
import io.ktor.client.plugins.HttpTimeoutConfig;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiationConfig;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiationKt;
import io.ktor.client.plugins.logging.LoggingConfig;
import io.ktor.client.plugins.logging.LoggingKt;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.serialization.Configuration;
import io.ktor.serialization.kotlinx.json.JsonSupportKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u00062\u001f\b\u0002\u0010\u0007\u001a\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0006H\u0000\u00a8\u0006\t"}, d2={"zetaHttpClient", "Lio/ktor/client/HttpClient;", "configure", "Lkotlin/Function1;", "Lde/gematik/zeta/sdk/network/http/client/config/ClientConfig;", "", "Lkotlin/ExtensionFunctionType;", "addExtras", "Lio/ktor/client/HttpClientConfig;", "network"})
@SourceDebugExtension(value={"SMAP\nZetaHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZetaHttpClient.kt\nde/gematik/zeta/sdk/network/http/client/ZetaHttpClientKt\n+ 2 Log.kt\nde/gematik/zeta/logging/Log\n*L\n1#1,139:1\n88#2,6:140\n168#2,9:146\n94#2:155\n88#2,6:156\n168#2,9:162\n94#2:171\n88#2,6:172\n168#2,9:178\n94#2:187\n88#2,6:188\n168#2,9:194\n94#2:203\n88#2,6:204\n168#2,9:210\n94#2:219\n*S KotlinDebug\n*F\n+ 1 ZetaHttpClient.kt\nde/gematik/zeta/sdk/network/http/client/ZetaHttpClientKt\n*L\n66#1:140,6\n66#1:146,9\n66#1:155\n77#1:156,6\n77#1:162,9\n77#1:171\n96#1:172,6\n96#1:178,9\n96#1:187\n109#1:188,6\n109#1:194,9\n109#1:203\n83#1:204,6\n83#1:210,9\n83#1:219\n*E\n"})
public final class ZetaHttpClientKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpClient zetaHttpClient(@NotNull Function1<? super ClientConfig, Unit> configure, @Nullable Function1<? super HttpClientConfig<?>, Unit> addExtras) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        Log $this$iv = Log.INSTANCE;
        ClientConfig throwable$iv = null;
        Object tag$iv = null;
        boolean $i$f$d = false;
        Log log = $this$iv;
        ClientConfig clientConfig = throwable$iv;
        Object var8_8 = tag$iv;
        LogLevel level$iv$iv = LogLevel.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv$iv.isEnabled(level$iv$iv)) {
            void tag$iv$iv;
            void throwable$iv$iv;
            void var15_11 = throwable$iv$iv;
            void var14_12 = tag$iv$iv;
            LogLevel logLevel = level$iv$iv;
            Napier napier = Napier.INSTANCE;
            boolean bl = false;
            String string = "Configuring the HTTP client";
            napier.log(logLevel, (String)var14_12, (Throwable)var15_11, string);
        }
        throwable$iv = new ClientConfig();
        configure.invoke((Object)throwable$iv);
        ClientConfig cfg = throwable$iv;
        Function1 commonSetup = arg_0 -> ZetaHttpClientKt.zetaHttpClient$lambda$14(cfg, addExtras, arg_0);
        Function0<HttpClientEngine> injected = cfg.getEngineFactory();
        return injected != null ? HttpClientKt.HttpClient((HttpClientEngine)((HttpClientEngine)injected.invoke()), arg_0 -> ZetaHttpClientKt.zetaHttpClient$lambda$15(commonSetup, arg_0)) : ZetaHttpClient_jvmKt.buildPlatformClient(cfg, commonSetup);
    }

    public static /* synthetic */ HttpClient zetaHttpClient$default(Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function12 = null;
        }
        return ZetaHttpClientKt.zetaHttpClient((Function1<? super ClientConfig, Unit>)function1, function12);
    }

    private static final Unit zetaHttpClient$lambda$14$lambda$2$lambda$1(ClientConfig $cfg, URLBuilder $this$url) {
        Intrinsics.checkNotNullParameter((Object)$this$url, (String)"$this$url");
        URLParserKt.takeFrom((URLBuilder)$this$url, (String)$cfg.getBaseUrlOverride());
        return Unit.INSTANCE;
    }

    private static final Unit zetaHttpClient$lambda$14$lambda$2(ClientConfig $cfg, DefaultRequest.DefaultRequestBuilder $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.url(arg_0 -> ZetaHttpClientKt.zetaHttpClient$lambda$14$lambda$2$lambda$1($cfg, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit zetaHttpClient$lambda$14$lambda$4(ClientConfig $cfg, HttpTimeoutConfig $this$install) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        Log $this$iv = Log.INSTANCE;
        Object throwable$iv = null;
        Object tag$iv = null;
        boolean $i$f$d = false;
        Log log = $this$iv;
        Object var7_7 = throwable$iv;
        Object var8_8 = tag$iv;
        LogLevel level$iv$iv = LogLevel.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv$iv.isEnabled(level$iv$iv)) {
            void tag$iv$iv;
            void throwable$iv$iv;
            void var15_11 = throwable$iv$iv;
            void var14_12 = tag$iv$iv;
            LogLevel logLevel = level$iv$iv;
            Napier napier = Napier.INSTANCE;
            boolean bl = false;
            String string = "Setting up the connection and request timeouts";
            napier.log(logLevel, (String)var14_12, (Throwable)var15_11, string);
        }
        $this$install.setConnectTimeoutMillis(Long.valueOf($cfg.getNetwork().getConnectionTimeoutMillis()));
        $this$install.setRequestTimeoutMillis(Long.valueOf($cfg.getNetwork().getRequestTimeoutMillis()));
        return Unit.INSTANCE;
    }

    private static final boolean zetaHttpClient$lambda$14$lambda$9$lambda$6(ClientConfig $cfg, HttpRetryShouldRetryContext $this$retryIf, HttpRequest request, HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)$this$retryIf, (String)"$this$retryIf");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        boolean methodOk = !$cfg.getNetwork().getRetryOnlyIdempotent() || ClientConfigKt.getIDEMPOTENT_METHODS().contains(request.getMethod());
        return methodOk && $cfg.getNetwork().getRetryStatusCodes().contains(response.getStatus());
    }

    private static final boolean zetaHttpClient$lambda$14$lambda$9$lambda$7(ClientConfig $cfg, HttpRetryShouldRetryContext $this$retryOnExceptionIf, HttpRequestBuilder request, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)$this$retryOnExceptionIf, (String)"$this$retryOnExceptionIf");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"<unused var>");
        return !$cfg.getNetwork().getRetryOnlyIdempotent() || ClientConfigKt.getIDEMPOTENT_METHODS().contains(request.getMethod());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit zetaHttpClient$lambda$14$lambda$9(ClientConfig $cfg, HttpRequestRetryConfig $this$install) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setMaxRetries($cfg.getNetwork().getMaxRetries());
        HttpRequestRetryConfig.retryIf$default((HttpRequestRetryConfig)$this$install, (int)0, (arg_0, arg_1, arg_2) -> ZetaHttpClientKt.zetaHttpClient$lambda$14$lambda$9$lambda$6($cfg, arg_0, arg_1, arg_2), (int)1, null);
        HttpRequestRetryConfig.retryOnExceptionIf$default((HttpRequestRetryConfig)$this$install, (int)0, (arg_0, arg_1, arg_2) -> ZetaHttpClientKt.zetaHttpClient$lambda$14$lambda$9$lambda$7($cfg, arg_0, arg_1, arg_2), (int)1, null);
        Log $this$iv = Log.INSTANCE;
        Object throwable$iv = null;
        Object tag$iv = null;
        boolean $i$f$d = false;
        Log log = $this$iv;
        Object var7_7 = throwable$iv;
        Object var8_8 = tag$iv;
        LogLevel level$iv$iv = LogLevel.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv$iv.isEnabled(level$iv$iv)) {
            void tag$iv$iv;
            void throwable$iv$iv;
            void var15_11 = throwable$iv$iv;
            void var14_12 = tag$iv$iv;
            LogLevel logLevel = level$iv$iv;
            Napier napier = Napier.INSTANCE;
            boolean bl = false;
            String string = "Setting up exponential backoff";
            napier.log(logLevel, (String)var14_12, (Throwable)var15_11, string);
        }
        HttpRequestRetryConfig.exponentialDelay$default((HttpRequestRetryConfig)$this$install, (double)0.0, (long)0L, (long)0L, (long)0L, (boolean)false, (int)31, null);
        return Unit.INSTANCE;
    }

    private static final Unit zetaHttpClient$lambda$14$lambda$10(ClientConfig $cfg, LoggingConfig $this$install) {
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        $this$install.setLevel($cfg.getMonitoring().getLogLevel());
        $this$install.setLogger($cfg.getMonitoring().getLogProvider());
        return Unit.INSTANCE;
    }

    private static final Unit zetaHttpClient$lambda$14$lambda$13$lambda$12(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit zetaHttpClient$lambda$14$lambda$13(ContentNegotiationConfig $this$install) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$install, (String)"$this$install");
        Log $this$iv = Log.INSTANCE;
        Object throwable$iv = null;
        Object tag$iv = null;
        boolean $i$f$d = false;
        Log log = $this$iv;
        Object var6_6 = throwable$iv;
        Object var7_7 = tag$iv;
        LogLevel level$iv$iv = LogLevel.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv$iv.isEnabled(level$iv$iv)) {
            void tag$iv$iv;
            void throwable$iv$iv;
            void var14_10 = throwable$iv$iv;
            void var13_11 = tag$iv$iv;
            LogLevel logLevel = level$iv$iv;
            Napier napier = Napier.INSTANCE;
            boolean bl = false;
            String string = "Installing ContentNegotiation JSON plugin";
            napier.log(logLevel, (String)var13_11, (Throwable)var14_10, string);
        }
        JsonSupportKt.json$default((Configuration)((Configuration)$this$install), (Json)JsonKt.Json$default(null, ZetaHttpClientKt::zetaHttpClient$lambda$14$lambda$13$lambda$12, (int)1, null), null, (int)2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit zetaHttpClient$lambda$14(ClientConfig $cfg, Function1 $addExtras, HttpClientConfig httpClientConfig) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)httpClientConfig, (String)"<this>");
            httpClientConfig.install((HttpClientPlugin)DefaultRequest.Plugin, arg_0 -> ZetaHttpClientKt.zetaHttpClient$lambda$14$lambda$2($cfg, arg_0));
            httpClientConfig.install((HttpClientPlugin)HttpTimeoutKt.getHttpTimeout(), arg_0 -> ZetaHttpClientKt.zetaHttpClient$lambda$14$lambda$4($cfg, arg_0));
            if ($cfg.getNetwork().getMaxRetries() > 0) {
                void this_$iv$iv;
                Log $this$iv = Log.INSTANCE;
                Object throwable$iv = null;
                Object tag$iv = null;
                boolean $i$f$d = false;
                Log log = $this$iv;
                Object var8_8 = throwable$iv;
                Object var9_9 = tag$iv;
                LogLevel level$iv$iv = LogLevel.DEBUG;
                boolean $i$f$log = false;
                if (this_$iv$iv.isEnabled(level$iv$iv)) {
                    void tag$iv$iv;
                    void throwable$iv$iv;
                    void var16_12 = throwable$iv$iv;
                    void var15_13 = tag$iv$iv;
                    LogLevel logLevel = level$iv$iv;
                    Napier napier = Napier.INSTANCE;
                    boolean bl = false;
                    String string = "Setting up the request retry plugin";
                    napier.log(logLevel, (String)var15_13, (Throwable)var16_12, string);
                }
                httpClientConfig.install((HttpClientPlugin)HttpRequestRetryKt.getHttpRequestRetry(), arg_0 -> ZetaHttpClientKt.zetaHttpClient$lambda$14$lambda$9($cfg, arg_0));
            }
            if ($cfg.getMonitoring().getLogLevel() != io.ktor.client.plugins.logging.LogLevel.NONE) {
                httpClientConfig.install((HttpClientPlugin)LoggingKt.getLogging(), arg_0 -> ZetaHttpClientKt.zetaHttpClient$lambda$14$lambda$10($cfg, arg_0));
            }
            httpClientConfig.install((HttpClientPlugin)ContentNegotiationKt.getContentNegotiation(), ZetaHttpClientKt::zetaHttpClient$lambda$14$lambda$13);
            Function1 function1 = $addExtras;
            if (function1 == null) break block3;
            function1.invoke((Object)httpClientConfig);
        }
        return Unit.INSTANCE;
    }

    private static final Unit zetaHttpClient$lambda$15(Function1 $commonSetup, HttpClientConfig $this$HttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$HttpClient, (String)"$this$HttpClient");
        $commonSetup.invoke((Object)$this$HttpClient);
        return Unit.INSTANCE;
    }
}

