/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.zeta.sdk.network.http.client;

import de.gematik.zeta.sdk.network.http.client.ZetaHttpClientKt;
import de.gematik.zeta.sdk.network.http.client.config.ClientConfig;
import de.gematik.zeta.sdk.network.http.client.config.MonitoringConfig;
import de.gematik.zeta.sdk.network.http.client.config.NetworkConfig;
import de.gematik.zeta.sdk.network.http.client.config.SecurityConfig;
import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.plugins.logging.LogLevel;
import io.ktor.client.plugins.logging.Logger;
import io.ktor.client.plugins.logging.LoggerJvmKt;
import io.ktor.http.HttpStatusCode;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J*\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003J\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dJ\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J'\u0010#\u001a\u00020$2\u001f\b\u0002\u0010%\u001a\u0019\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0004\u0012\u00020(\u0018\u00010&\u00a2\u0006\u0002\b)J\u0012\u0010#\u001a\u00020$2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/gematik/zeta/sdk/network/http/client/ZetaHttpClientBuilder;", "", "baseUrl", "", "<init>", "(Ljava/lang/String;)V", "network", "Lde/gematik/zeta/sdk/network/http/client/config/NetworkConfig;", "security", "Lde/gematik/zeta/sdk/network/http/client/config/SecurityConfig;", "monitoring", "Lde/gematik/zeta/sdk/network/http/client/config/MonitoringConfig;", "timeouts", "connectMs", "", "requestMs", "(Ljava/lang/Long;Ljava/lang/Long;)Lde/gematik/zeta/sdk/network/http/client/ZetaHttpClientBuilder;", "retry", "statusCodes", "", "Lio/ktor/http/HttpStatusCode;", "maxRetries", "", "onlyIdempotent", "", "addCaPem", "pem", "setCaPems", "pems", "", "logging", "level", "Lio/ktor/client/plugins/logging/LogLevel;", "logProvider", "Lio/ktor/client/plugins/logging/Logger;", "build", "Lio/ktor/client/HttpClient;", "addExtras", "Lkotlin/Function1;", "Lio/ktor/client/HttpClientConfig;", "", "Lkotlin/ExtensionFunctionType;", "engine", "Lio/ktor/client/engine/HttpClientEngine;"})
public final class ZetaHttpClientBuilder {
    @NotNull
    private final String baseUrl;
    @NotNull
    private NetworkConfig network;
    @NotNull
    private SecurityConfig security;
    @NotNull
    private MonitoringConfig monitoring;

    public ZetaHttpClientBuilder(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = baseUrl;
        this.network = new NetworkConfig(0L, 0L, null, 0, false, 31, null);
        this.security = new SecurityConfig(null, 1, null);
        this.monitoring = new MonitoringConfig(null, null, 3, null);
    }

    @NotNull
    public final ZetaHttpClientBuilder timeouts(@Nullable Long connectMs, @Nullable Long requestMs) {
        ZetaHttpClientBuilder zetaHttpClientBuilder;
        ZetaHttpClientBuilder $this$timeouts_u24lambda_u240 = zetaHttpClientBuilder = this;
        boolean bl = false;
        Long l = connectMs;
        Long l2 = requestMs;
        $this$timeouts_u24lambda_u240.network = NetworkConfig.copy$default($this$timeouts_u24lambda_u240.network, l != null ? l.longValue() : $this$timeouts_u24lambda_u240.network.getConnectionTimeoutMillis(), l2 != null ? l2.longValue() : $this$timeouts_u24lambda_u240.network.getRequestTimeoutMillis(), null, 0, false, 28, null);
        return zetaHttpClientBuilder;
    }

    public static /* synthetic */ ZetaHttpClientBuilder timeouts$default(ZetaHttpClientBuilder zetaHttpClientBuilder, Long l, Long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = null;
        }
        if ((n & 2) != 0) {
            l2 = null;
        }
        return zetaHttpClientBuilder.timeouts(l, l2);
    }

    @NotNull
    public final ZetaHttpClientBuilder retry(@NotNull Set<HttpStatusCode> statusCodes, int maxRetries, boolean onlyIdempotent) {
        ZetaHttpClientBuilder zetaHttpClientBuilder;
        Intrinsics.checkNotNullParameter(statusCodes, (String)"statusCodes");
        ZetaHttpClientBuilder $this$retry_u24lambda_u241 = zetaHttpClientBuilder = this;
        boolean bl = false;
        $this$retry_u24lambda_u241.network = NetworkConfig.copy$default($this$retry_u24lambda_u241.network, 0L, 0L, statusCodes, maxRetries, onlyIdempotent, 3, null);
        return zetaHttpClientBuilder;
    }

    public static /* synthetic */ ZetaHttpClientBuilder retry$default(ZetaHttpClientBuilder zetaHttpClientBuilder, Set set, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            set = zetaHttpClientBuilder.network.getRetryStatusCodes();
        }
        if ((n2 & 2) != 0) {
            n = zetaHttpClientBuilder.network.getMaxRetries();
        }
        if ((n2 & 4) != 0) {
            bl = zetaHttpClientBuilder.network.getRetryOnlyIdempotent();
        }
        return zetaHttpClientBuilder.retry(set, n, bl);
    }

    @NotNull
    public final ZetaHttpClientBuilder addCaPem(@NotNull String pem) {
        ZetaHttpClientBuilder zetaHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        ZetaHttpClientBuilder $this$addCaPem_u24lambda_u242 = zetaHttpClientBuilder = this;
        boolean bl = false;
        $this$addCaPem_u24lambda_u242.security = $this$addCaPem_u24lambda_u242.security.copy(CollectionsKt.plus((Collection)$this$addCaPem_u24lambda_u242.security.getAdditionalCaPem(), (Object)pem));
        return zetaHttpClientBuilder;
    }

    @NotNull
    public final ZetaHttpClientBuilder setCaPems(@NotNull List<String> pems) {
        ZetaHttpClientBuilder zetaHttpClientBuilder;
        Intrinsics.checkNotNullParameter(pems, (String)"pems");
        ZetaHttpClientBuilder $this$setCaPems_u24lambda_u243 = zetaHttpClientBuilder = this;
        boolean bl = false;
        $this$setCaPems_u24lambda_u243.security = $this$setCaPems_u24lambda_u243.security.copy(CollectionsKt.toList((Iterable)pems));
        return zetaHttpClientBuilder;
    }

    @NotNull
    public final ZetaHttpClientBuilder logging(@NotNull LogLevel level, @NotNull Logger logProvider) {
        ZetaHttpClientBuilder zetaHttpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)logProvider, (String)"logProvider");
        ZetaHttpClientBuilder $this$logging_u24lambda_u244 = zetaHttpClientBuilder = this;
        boolean bl = false;
        $this$logging_u24lambda_u244.monitoring = $this$logging_u24lambda_u244.monitoring.copy(level, logProvider);
        return zetaHttpClientBuilder;
    }

    public static /* synthetic */ ZetaHttpClientBuilder logging$default(ZetaHttpClientBuilder zetaHttpClientBuilder, LogLevel logLevel, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            logger = LoggerJvmKt.getDEFAULT((Logger.Companion)Logger.Companion);
        }
        return zetaHttpClientBuilder.logging(logLevel, logger);
    }

    @NotNull
    public final HttpClient build() {
        return ZetaHttpClientKt.zetaHttpClient$default(arg_0 -> ZetaHttpClientBuilder.build$lambda$5(this, arg_0), null, 2, null);
    }

    @NotNull
    public final HttpClient build(@Nullable Function1<? super HttpClientConfig<?>, Unit> addExtras) {
        return ZetaHttpClientKt.zetaHttpClient((Function1<? super ClientConfig, Unit>)((Function1)arg_0 -> ZetaHttpClientBuilder.build$lambda$6(this, arg_0)), addExtras);
    }

    public static /* synthetic */ HttpClient build$default(ZetaHttpClientBuilder zetaHttpClientBuilder, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return zetaHttpClientBuilder.build(function1);
    }

    @NotNull
    public final HttpClient build(@Nullable HttpClientEngine engine) {
        return ZetaHttpClientKt.zetaHttpClient$default(arg_0 -> ZetaHttpClientBuilder.build$lambda$7(this, engine, arg_0), null, 2, null);
    }

    public static /* synthetic */ HttpClient build$default(ZetaHttpClientBuilder zetaHttpClientBuilder, HttpClientEngine httpClientEngine, int n, Object object) {
        if ((n & 1) != 0) {
            httpClientEngine = null;
        }
        return zetaHttpClientBuilder.build(httpClientEngine);
    }

    private static final Unit build$lambda$5(ZetaHttpClientBuilder this$0, ClientConfig $this$zetaHttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$zetaHttpClient, (String)"$this$zetaHttpClient");
        $this$zetaHttpClient.setBaseUrlOverride(this$0.baseUrl);
        $this$zetaHttpClient.setNetwork(this$0.network);
        $this$zetaHttpClient.setSecurity(this$0.security);
        $this$zetaHttpClient.setMonitoring(this$0.monitoring);
        return Unit.INSTANCE;
    }

    private static final Unit build$lambda$6(ZetaHttpClientBuilder this$0, ClientConfig $this$zetaHttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$zetaHttpClient, (String)"$this$zetaHttpClient");
        $this$zetaHttpClient.setBaseUrlOverride(this$0.baseUrl);
        $this$zetaHttpClient.setNetwork(this$0.network);
        $this$zetaHttpClient.setSecurity(this$0.security);
        $this$zetaHttpClient.setMonitoring(this$0.monitoring);
        return Unit.INSTANCE;
    }

    private static final Unit build$lambda$7(ZetaHttpClientBuilder this$0, HttpClientEngine $engine, ClientConfig $this$zetaHttpClient) {
        Intrinsics.checkNotNullParameter((Object)$this$zetaHttpClient, (String)"$this$zetaHttpClient");
        $this$zetaHttpClient.setBaseUrlOverride(this$0.baseUrl);
        $this$zetaHttpClient.setNetwork(this$0.network);
        $this$zetaHttpClient.setSecurity(this$0.security);
        $this$zetaHttpClient.setMonitoring(this$0.monitoring);
        if ($engine != null) {
            $this$zetaHttpClient.engine($engine);
        }
        return Unit.INSTANCE;
    }
}

