/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.rs.vau.CipherConfiguration;
import de.gematik.rs.vau.CipherConfiguration_;
import de.gematik.rs.vau.VAUClientSigFin;
import de.gematik.rs.vau.VAUServerFin;
import de.gematik.rs.vau.VAUServerHello;
import de.gematik.ti.vauchannel.protocol.VAUProtocolCrypto;
import de.gematik.ti.vauchannel.protocol.VAUProtocolSession;
import de.gematik.ti.vauchannel.protocol.helpers.AESGCM;
import de.gematik.ti.vauchannel.protocol.helpers.Base64;
import de.gematik.ti.vauchannel.protocol.helpers.ObjectMapperFactory;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VAUProtocolHelpers {
    static final Logger logger = LoggerFactory.getLogger(VAUProtocolHelpers.class);
    private static final String OID_EPA_VAU = "1.2.276.0.76.4.209";
    static ObjectMapper mapper = ObjectMapperFactory.objectMapper();

    public static List<CipherConfiguration> getCipherConfiguration() {
        ArrayList<CipherConfiguration> cipherConfiguration = new ArrayList<CipherConfiguration>();
        cipherConfiguration.add(CipherConfiguration.AES_256_GCM_BRAINPOOL_P_256_R_1_SHA_256);
        return cipherConfiguration;
    }

    public static List<CipherConfiguration_> getCipherConfiguration_() {
        ArrayList<CipherConfiguration_> cipherConfiguration = new ArrayList<CipherConfiguration_>();
        cipherConfiguration.add(CipherConfiguration_.AES_256_GCM_BRAINPOOL_P_256_R_1_SHA_256);
        return cipherConfiguration;
    }

    public static void checkClientSignature(VAUClientSigFin vAUClientSigFin, VAUProtocolCrypto crypto) {
        boolean signatureOk;
        try {
            logger.info("ClientSignature: " + vAUClientSigFin.getSignature());
            byte[] signature = Base64.decode(vAUClientSigFin.getSignature());
            byte[] message = VAUProtocolHelpers.concat(vAUClientSigFin.getVAUClientHelloDataHash().getBytes(StandardCharsets.UTF_8), vAUClientSigFin.getVAUServerHelloDataHash().getBytes(StandardCharsets.UTF_8));
            byte[] certBytes = Base64.decode(vAUClientSigFin.getCertificate());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream in = new ByteArrayInputStream(certBytes);
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
            PublicKey pk = cert.getPublicKey();
            signatureOk = crypto.verify(message, signature, pk);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Exception");
        }
        if (!signatureOk) {
            throw new RuntimeException("Signature from VAUClientSigFin invalid");
        }
    }

    public static void checkServerSignature(VAUServerHello vAUServerHello, VAUProtocolCrypto crypto) {
        boolean signatureOk;
        try {
            logger.info("ServerSignature: " + vAUServerHello.getSignature());
            byte[] signature = Base64.decode(vAUServerHello.getSignature());
            byte[] message = vAUServerHello.getData().getBytes(StandardCharsets.UTF_8);
            byte[] certBytes = Base64.decode(vAUServerHello.getCertificate());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream in = new ByteArrayInputStream(certBytes);
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
            PublicKey pk = cert.getPublicKey();
            crypto.checkServerCertificate(cert);
            signatureOk = crypto.verify(message, signature, pk);
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new RuntimeException("Error during server-signature check", e);
        }
        if (!signatureOk) {
            throw new RuntimeException("Signature from VAUServerHello invalid");
        }
    }

    private static void checkServerCertificate(X509Certificate cert, VAUProtocolCrypto crypto) {
        try {
            cert.checkValidity();
            VAUProtocolHelpers.checkVauServerCertificateExtension(cert);
            crypto.checkServerCertificate(cert);
        }
        catch (Exception e) {
            throw new RuntimeException("VAUServerCertificate not valid", e);
        }
    }

    public static void checkVauServerCertificateExtension(X509Certificate cert) throws CertificateEncodingException {
        ASN1Encodable parsedValue = Certificate.getInstance((Object)cert.getEncoded()).getTBSCertificate().getExtensions().getExtension(new ASN1ObjectIdentifier("1.3.36.8.3.3")).getParsedValue();
        DLSequence a = (DLSequence)parsedValue;
        DLSequence b = (DLSequence)a.getObjectAt(0);
        DLSequence c = (DLSequence)b.getObjectAt(0);
        DLSequence d = (DLSequence)c.getObjectAt(0);
        DLSequence e = (DLSequence)d.getObjectAt(0);
        DLSequence f = (DLSequence)e.getObjectAt(1);
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)f.getObjectAt(0);
        if (!oid.getId().equals(OID_EPA_VAU)) {
            throw new RuntimeException("Invalid extension detected: " + oid.getId());
        }
    }

    public static void checkFinishedDataFromClient(VAUProtocolSession serverSession, VAUClientSigFin vAUClientSigFin, byte[] expectedVauClientHelloDataHash, byte[] expectedVauServerHelloDataHash) {
        String errorMessage = "VAUClientSigFin invalid";
        byte[] finishedDataBytes = Base64.decode(vAUClientSigFin.getFinishedData());
        byte[] keyidOnServer = serverSession.getKeyID();
        byte[] keyidFromClient = new byte[keyidOnServer.length];
        System.arraycopy(finishedDataBytes, 0, keyidFromClient, 0, keyidOnServer.length);
        if (!Arrays.equals(keyidOnServer, keyidFromClient)) {
            logger.error("KeyID on Server " + Base64.encode2String(keyidOnServer) + " not equals KeyID on Client " + Base64.encode2String(keyidFromClient));
            throw new RuntimeException(errorMessage);
        }
        byte[] encryptedMessageFromClient = new byte[finishedDataBytes.length - keyidOnServer.length];
        System.arraycopy(finishedDataBytes, keyidOnServer.length, encryptedMessageFromClient, 0, encryptedMessageFromClient.length);
        byte[] decryptedMessage = null;
        try {
            decryptedMessage = AESGCM.decrypt(encryptedMessageFromClient, serverSession.getSymKeyClientToServer());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(errorMessage);
        }
        byte[] expectedConcatenatedHashesUncoded = VAUProtocolHelpers.concat(expectedVauClientHelloDataHash, expectedVauServerHelloDataHash);
        if (!Base64.encode2String(expectedVauClientHelloDataHash).equals(vAUClientSigFin.getVAUClientHelloDataHash())) {
            logger.error("expected vauClientHelloDataHash " + Base64.encode2String(expectedVauClientHelloDataHash) + " but got " + vAUClientSigFin.getVAUClientHelloDataHash());
            throw new RuntimeException(errorMessage);
        }
        if (!Base64.encode2String(expectedVauServerHelloDataHash).equals(vAUClientSigFin.getVAUServerHelloDataHash())) {
            logger.error("expected vauServerHelloDataHash " + Base64.encode2String(expectedVauServerHelloDataHash) + " but got " + vAUClientSigFin.getVAUServerHelloDataHash());
            throw new RuntimeException(errorMessage);
        }
        byte[] expectedMessage = VAUProtocolHelpers.concat("VAUClientSigFin".getBytes(StandardCharsets.UTF_8), expectedConcatenatedHashesUncoded);
        if (expectedMessage.length != 79) {
            logger.error("message.length = " + expectedMessage.length + ", expected is 79");
            throw new RuntimeException(errorMessage);
        }
        if (!Arrays.equals(decryptedMessage, expectedMessage)) {
            logger.error("decryptedMessage = " + decryptedMessage + " not equals expectedMessage = " + expectedMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    public static void checkFinishedDataFromServer(VAUProtocolSession session, VAUServerFin vAUServerFin) {
        byte[] vauClientHelloDataHash = session.getClientHelloDataHash();
        byte[] vauServerHelloDataHash = session.getServerHelloDataHash();
        String errorMessage = "VAUServerFin invalid";
        byte[] finishedDataBytes = Base64.decode(vAUServerFin.getFinishedData());
        byte[] keyidOnServer = session.getKeyID();
        byte[] keyidFromServer = new byte[keyidOnServer.length];
        System.arraycopy(finishedDataBytes, 0, keyidFromServer, 0, keyidOnServer.length);
        if (!Arrays.equals(keyidOnServer, keyidFromServer)) {
            logger.error("KeyID on Server " + Base64.encode2String(keyidOnServer) + " not equals KeyID on Client " + Base64.encode2String(keyidFromServer));
            throw new RuntimeException(errorMessage);
        }
        byte[] encryptedMessageFromServer = new byte[finishedDataBytes.length - keyidOnServer.length];
        System.arraycopy(finishedDataBytes, keyidOnServer.length, encryptedMessageFromServer, 0, encryptedMessageFromServer.length);
        byte[] decryptedMessage = null;
        try {
            decryptedMessage = AESGCM.decrypt(encryptedMessageFromServer, session.getSymKeyServerToClient());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(errorMessage);
        }
        byte[] concatenatedHashesUncoded = VAUProtocolHelpers.concat(vauClientHelloDataHash, vauServerHelloDataHash);
        byte[] expectedMessage = VAUProtocolHelpers.concat("VAUServerFin".getBytes(StandardCharsets.UTF_8), concatenatedHashesUncoded);
        if (expectedMessage.length != 76) {
            logger.error("message.length = " + expectedMessage.length + ", expected is 76");
            throw new RuntimeException(errorMessage);
        }
        if (!Arrays.equals(decryptedMessage, expectedMessage)) {
            logger.error("decryptedMessage = " + decryptedMessage + " not equals expectedMessage = " + expectedMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    public static String prettyJson(String str) {
        try {
            Object json = mapper.readValue(str, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (Exception ex) {
            logger.info("couldn't pretty print json");
            return str;
        }
    }

    public static void logJSON(Object o) {
        String str = null;
        if (o instanceof String) {
            str = (String)o;
        } else {
            try {
                str = mapper.writeValueAsString(o);
            }
            catch (JsonProcessingException ex) {
                logger.error("", (Throwable)ex);
            }
        }
        logger.info(VAUProtocolHelpers.prettyJson(str));
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static void checkClientCertificateHash(VAUClientSigFin vAUClientSigFin, VAUProtocolCrypto crypto, VAUProtocolSession session) {
        logger.debug("VAUProtocolSession session: " + session.toString());
        byte[] hashA = session.getClientHelloDataCertificateHash();
        byte[] hashB = crypto.hash(Base64.decode(vAUClientSigFin.getCertificate()));
        if (!Arrays.equals(hashA, hashB)) {
            try {
                if (hashA == null) {
                    logger.error("hashA is null");
                } else {
                    logger.error("hashA from ClientHelloDataCertificateHash: " + Base64.encode2String(hashA));
                }
                logger.error("hashB from vAUClientSigFin.getCertificate(): " + Base64.encode2String(hashB));
                logger.error("!Arrays.equals(hashA, hashB)");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException("Client Certificate inconsistent");
        }
    }
}

