/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import de.gematik.ti.vauchannel.protocol.VAUProtocolCrypto;
import de.gematik.ti.vauchannel.protocol.VAUProtocolSession;
import de.gematik.ti.vauchannel.protocol.helpers.AESGCM;
import de.gematik.ti.vauchannel.protocol.helpers.Identity;
import de.gematik.ti.vauchannel.protocol.helpers.KeyPairGenerator;
import de.gematik.ti.vauchannel.protocol.helpers.OCSPResponseGenerator;
import de.gematik.ti.vauchannel.protocol.helpers.VAUProtocolHelpers;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import javax.crypto.KeyAgreement;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VAUProtocolCryptoImpl
implements VAUProtocolCrypto {
    private static final Logger logger = LoggerFactory.getLogger(VAUProtocolCryptoImpl.class);
    boolean doValidateAuthorizationAssertion;
    boolean ecc;
    private Identity eeIdentity;
    private Identity ocspSignerIdentity;
    private X509Certificate caCertificate;

    public VAUProtocolCryptoImpl(boolean ecc) {
        this.ecc = ecc;
        try {
            this.eeIdentity = ecc ? Identity.generateSelfSigned_ECC() : Identity.generateSelfSigned_RSA();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public VAUProtocolCryptoImpl() {
        this(false, null, null, null);
    }

    public VAUProtocolCryptoImpl(boolean ecc, Identity eeIdentity) {
        this(ecc, eeIdentity, null, null);
    }

    public VAUProtocolCryptoImpl(boolean ecc, Identity eeIdentity, X509Certificate caCertificate, Identity ocspSignerIdentity) {
        this(false, ecc, eeIdentity, caCertificate, ocspSignerIdentity);
    }

    public VAUProtocolCryptoImpl(boolean doValidateAuthorizationAssertion, boolean ecc, Identity eeIdentity, X509Certificate caCertificate, Identity ocspSignerIdentity) {
        this.doValidateAuthorizationAssertion = doValidateAuthorizationAssertion;
        this.ecc = ecc;
        this.eeIdentity = eeIdentity;
        this.caCertificate = caCertificate;
        this.ocspSignerIdentity = ocspSignerIdentity;
    }

    @Override
    public LocalDateTime now() {
        return LocalDateTime.now();
    }

    @Override
    public byte[] hash(byte[] in) {
        byte[] out;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(in);
            out = sha.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException("internal vau protocol exception");
        }
        return out;
    }

    @Override
    public byte[] ECKA(PrivateKey prk, PublicKey puk) throws Exception {
        KeyAgreement ka = KeyAgreement.getInstance("ECDH", "BC");
        ka.init(prk);
        ka.doPhase(puk, true);
        byte[] sharedSecret = ka.generateSecret();
        return sharedSecret;
    }

    @Override
    public byte[] HKDF(byte[] ikm, String info, int length) throws IllegalArgumentException, DataLengthException {
        return this.HKDF(ikm, info.getBytes(), length);
    }

    @Override
    public byte[] HKDF(byte[] ikm, byte[] info, int length) throws IllegalArgumentException, DataLengthException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(ikm, null, info));
        byte[] okm = new byte[length / 8];
        hkdf.generateBytes(okm, 0, length / 8);
        return okm;
    }

    @Override
    public boolean verify(byte[] message, byte[] signatureBytes, PublicKey puk) {
        try {
            return this.verifyECDSA(message, signatureBytes, puk);
        }
        catch (Exception eA) {
            try {
                return this.verifyRSASSA_PSS(message, signatureBytes, puk);
            }
            catch (Exception eB) {
                logger.error("verify not successful:");
                logger.error(eA.getMessage(), (Throwable)eA);
                logger.error(eB.getMessage(), (Throwable)eB);
                return false;
            }
        }
    }

    private boolean verifyRSASSA_PSS(byte[] message, byte[] signatureBytes, PublicKey puk) throws Exception {
        Signature signer = Signature.getInstance("SHA256withRSAAndMGF1", "BC");
        signer.initVerify(puk);
        signer.update(message);
        return signer.verify(signatureBytes);
    }

    private boolean verifyECDSA(byte[] message, byte[] signatureBytes, PublicKey puk) throws Exception {
        Signature signer = Signature.getInstance("SHA256withECDSA", "BC");
        signer.initVerify(puk);
        signer.update(message);
        return signer.verify(signatureBytes);
    }

    private byte[] signRSASSA_PSS(byte[] message, PrivateKey prk) throws Exception {
        String algorithm = "SHA256withRSAAndMGF1";
        return this.sign(message, prk, algorithm);
    }

    private byte[] sign(byte[] message, PrivateKey prk, String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException {
        return this.plainSignature(message, prk, algorithm);
    }

    private byte[] plainSignature(byte[] message, PrivateKey prk, String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signer = Signature.getInstance(algorithm, "BC");
        signer.initSign(prk);
        signer.update(message);
        return signer.sign();
    }

    private byte[] signECDSA(byte[] message, PrivateKey prk) throws Exception {
        return this.sign(message, prk, "SHA256withECDSA");
    }

    @Override
    public byte[] signRSASSA_PSS(byte[] message) throws Exception {
        return this.signRSASSA_PSS(message, this.eeIdentity.privateKey);
    }

    @Override
    public byte[] signECDSA(byte[] message) throws Exception {
        return this.signECDSA(message, this.eeIdentity.privateKey);
    }

    @Override
    public KeyPair generateECCKeyPair() {
        try {
            return KeyPairGenerator.generateECCKeyPair();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("internal vau protocol exception");
        }
    }

    @Override
    public PublicKey eccPublicKeyFromBytes(byte[] pubKey) {
        try {
            return KeyFactory.getInstance("ECDSA", "BC").generatePublic(new X509EncodedKeySpec(pubKey));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("internal vau protocol exception");
        }
    }

    @Override
    public OCSPResp getOcspResponse() {
        try {
            return OCSPResponseGenerator.gen(this.eeIdentity.certificate, this.caCertificate, this.ocspSignerIdentity.certificate, this.ocspSignerIdentity.privateKey, CertificateStatus.GOOD);
        }
        catch (CertificateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("internal vau protocol exception");
        }
    }

    @Override
    public X509Certificate getEECertificate() {
        return this.eeIdentity.certificate;
    }

    @Override
    public boolean isECCIdentity() {
        return this.ecc;
    }

    @Override
    public boolean canProvideOcspResponse() {
        return this.ocspSignerIdentity != null;
    }

    @Override
    public byte[] encrypt_AESGCM(byte[] plain, byte[] symKey, long counter) throws Exception {
        return AESGCM.encrypt(plain, symKey, counter);
    }

    @Override
    public byte[] decrypt_AESGCM(byte[] encrypted, byte[] symKey, long counter) throws Exception {
        return AESGCM.decrypt(encrypted, symKey);
    }

    @Override
    public void validateAuthorizationAssertion(VAUProtocolSession vauProtocolSession, String authorizationAssertionStr) {
    }

    @Override
    public void checkServerCertificate(X509Certificate cert) {
        try {
            cert.checkValidity();
            this.performTslCheckForCertificate(cert);
            VAUProtocolHelpers.checkVauServerCertificateExtension(cert);
            this.performOcspCheckForCertificate(cert);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while verifying vau-server-certificate", e);
        }
    }

    @Override
    public void performOcspCheckForCertificate(X509Certificate cert) throws Exception {
    }

    @Override
    public void performTslCheckForCertificate(X509Certificate cert) throws Exception {
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

