/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyPairGenerator {
    public static final int KEY_SIZE = 2048;
    private static final SecureRandom SECURE_RANDOM;

    public static KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        java.security.KeyPairGenerator generator = java.security.KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(2048, SECURE_RANDOM);
        return generator.generateKeyPair();
    }

    public static KeyPair generateECCKeyPair(String spec) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        java.security.KeyPairGenerator kpg = java.security.KeyPairGenerator.getInstance("EC", "BC");
        ECGenParameterSpec namedParameterSpec = new ECGenParameterSpec(spec);
        kpg.initialize(namedParameterSpec, SECURE_RANDOM);
        return kpg.generateKeyPair();
    }

    public static KeyPair generateECCKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairGenerator.generateECCKeyPair("brainpoolp256r1");
    }

    public static X509Certificate selfSign(KeyPair keyPair, String subjectDN, String signatureAlgorithm) throws OperatorCreationException, CertificateException, IOException, NoSuchProviderException {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        X500Name dnName = new X500Name(subjectDN);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, keyPair.getPublic());
        X509CertificateHolder h = certBuilder.build(contentSigner);
        X509Certificate c = new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(h);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream in = new ByteArrayInputStream(c.getEncoded());
        return (X509Certificate)certFactory.generateCertificate(in);
    }

    public static X509Certificate generateCertificate(KeyPair keyPair, String subjectDN, String signatureAlgorithm) throws Exception {
        Date NOT_BEFORE = new Date();
        Calendar NOT_AFTER = Calendar.getInstance();
        NOT_AFTER.add(1, 100);
        X500Name subjectAndIssuer = new X500Name("CN=peercentrum node");
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(subjectAndIssuer, new BigInteger("42"), NOT_BEFORE, NOT_AFTER.getTime(), subjectAndIssuer, keyPair.getPublic());
        DLSequence extension = new DLSequence((ASN1Encodable)new DLSequence((ASN1Encodable)new DLSequence((ASN1Encodable)new DLSequence((ASN1Encodable)new DLSequence(new ASN1Encodable[]{new DLSequence((ASN1Encodable)new DERUTF8String("ePA vertrauensw\u00fcrdige Ausf\u00fchrungsumgebung")), new DLSequence((ASN1Encodable)new ASN1ObjectIdentifier("1.2.276.0.76.4.209"))})))));
        certificateBuilder.addExtension(new ASN1ObjectIdentifier("1.3.36.8.3.3"), false, (ASN1Encodable)extension);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(keyPair.getPrivate());
        X509CertificateHolder certHolder = certificateBuilder.build(signer);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
    }

    static {
        try {
            SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Startup exception", e);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

