/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol.helpers;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESGCM {
    public static final int AES_KEY_SIZE = 32;
    public static final int GCM_IV_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 16;
    private static final Logger logger = LoggerFactory.getLogger(AESGCM.class);

    private static GCMParameterSpec getGCMParameterSpec(byte[] iv) {
        return new GCMParameterSpec(128, iv);
    }

    public static byte[] encrypt(byte[] input, byte[] key, long counter) throws Exception {
        return AESGCM.encrypt(input, key, null, counter);
    }

    public static byte[] encrypt(byte[] input, byte[] key) throws Exception {
        return AESGCM.encrypt(input, key, null);
    }

    public static byte[] encrypt(byte[] input, byte[] key, byte[] associatedData) throws Exception {
        byte[] iv = AESGCM.generateIV();
        return AESGCM.encrypt(input, key, associatedData, iv);
    }

    public static byte[] encrypt(byte[] input, byte[] key, byte[] associatedData, long counter) throws Exception {
        byte[] iv = AESGCM.generateIV(counter);
        return AESGCM.encrypt(input, key, associatedData, iv);
    }

    private static byte[] encrypt(byte[] input, byte[] key, byte[] associatedData, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        Cipher cipher = AESGCM.getCipher();
        cipher.init(1, (Key)secretKey, AESGCM.getGCMParameterSpec(iv));
        if (associatedData != null) {
            cipher.updateAAD(associatedData);
        }
        byte[] cipherTextPlusTag = cipher.doFinal(input);
        byte[] encMessage = Arrays.copyOf(iv, 12 + cipherTextPlusTag.length);
        System.arraycopy(cipherTextPlusTag, 0, encMessage, 12, cipherTextPlusTag.length);
        return encMessage;
    }

    public static byte[] decrypt(byte[] encMessage, byte[] key) throws Exception {
        return AESGCM.decrypt(encMessage, key, null);
    }

    public static byte[] decrypt(byte[] encMessage, byte[] key, byte[] associatedData) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        byte[] iv = Arrays.copyOfRange(encMessage, 0, 12);
        byte[] cipherText = Arrays.copyOfRange(encMessage, 12, encMessage.length);
        Cipher cipher = AESGCM.getCipher();
        cipher.init(2, (Key)secretKey, AESGCM.getGCMParameterSpec(iv));
        if (associatedData != null) {
            cipher.updateAAD(associatedData);
        }
        byte[] plainText = cipher.doFinal(cipherText);
        return plainText;
    }

    private static Cipher getCipher() {
        try {
            return Cipher.getInstance("AES/GCM/NoPadding", "BC");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateIV() {
        byte[] iv = new byte[12];
        ThreadLocalRandom.current().nextBytes(iv);
        return iv;
    }

    public static byte[] generateIV(long counter) {
        byte[] iv = new byte[12];
        ThreadLocalRandom.current().nextBytes(iv);
        byte[] counterBytes = AESGCM.longToBytes(counter);
        System.arraycopy(counterBytes, 0, iv, 4, counterBytes.length);
        return iv;
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, x);
        return buffer.array();
    }

    public static SecretKey keyFromBytes(byte[] encodedKey) {
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }

    public static SecretKey generateSymmetricKey() {
        SecretKey key = null;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            key = keyGen.generateKey();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return key;
    }

    public static CipherOutputStream encrypt(OutputStream os, byte[] key) {
        byte[] iv = AESGCM.generateIV();
        CipherOutputStream cos = null;
        try {
            os.write(iv);
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = AESGCM.getCipher();
            cipher.init(1, (Key)secretKey, AESGCM.getGCMParameterSpec(iv));
            cos = new CipherOutputStream(os, (StreamCipher)cipher);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return cos;
    }
}

