/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol;

import de.gematik.ti.vauchannel.protocol.VAUProtocolSessionState;
import java.security.KeyPair;
import java.util.Arrays;

public class VAUProtocolSession {
    private byte[] keyID;
    private byte[] symKeyClientToServer;
    private byte[] symKeyServerToClient;
    private byte[] clientHelloDataHash;
    private byte[] clientHelloDataCertificateHash;
    private byte[] serverHelloDataHash;
    private KeyPair ephemeralKeyPair;
    private byte[] hash;
    private byte[] share;
    private byte[] authzToken;
    private String recordIDFromAuthzToken;
    private long counter;
    private boolean client;
    private boolean forceErrorInDecryptIfCountIs5;
    private boolean forceErrorInEncryptIfCountIs6;
    private VAUProtocolSessionState state;

    public VAUProtocolSession(boolean client) {
        this.client = client;
        this.state = VAUProtocolSessionState.handshaking;
    }

    public void initialize() {
        this.counter = 0L;
        this.keyID = null;
        this.symKeyClientToServer = null;
        this.symKeyServerToClient = null;
        this.clientHelloDataHash = null;
        this.serverHelloDataHash = null;
        this.ephemeralKeyPair = null;
        this.hash = null;
        this.share = null;
        this.authzToken = null;
        this.recordIDFromAuthzToken = null;
    }

    public static VAUProtocolSessionBuilder builder() {
        return new VAUProtocolSessionBuilder();
    }

    public byte[] getKeyID() {
        return this.keyID;
    }

    public byte[] getSymKeyClientToServer() {
        return this.symKeyClientToServer;
    }

    public byte[] getSymKeyServerToClient() {
        return this.symKeyServerToClient;
    }

    public byte[] getClientHelloDataHash() {
        return this.clientHelloDataHash;
    }

    public byte[] getClientHelloDataCertificateHash() {
        return this.clientHelloDataCertificateHash;
    }

    public byte[] getServerHelloDataHash() {
        return this.serverHelloDataHash;
    }

    public KeyPair getEphemeralKeyPair() {
        return this.ephemeralKeyPair;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getShare() {
        return this.share;
    }

    public byte[] getAuthzToken() {
        return this.authzToken;
    }

    public String getRecordIDFromAuthzToken() {
        return this.recordIDFromAuthzToken;
    }

    public long getCounter() {
        return this.counter;
    }

    public boolean isClient() {
        return this.client;
    }

    public boolean isForceErrorInDecryptIfCountIs5() {
        return this.forceErrorInDecryptIfCountIs5;
    }

    public boolean isForceErrorInEncryptIfCountIs6() {
        return this.forceErrorInEncryptIfCountIs6;
    }

    public VAUProtocolSessionState getState() {
        return this.state;
    }

    public void setKeyID(byte[] keyID) {
        this.keyID = keyID;
    }

    public void setSymKeyClientToServer(byte[] symKeyClientToServer) {
        this.symKeyClientToServer = symKeyClientToServer;
    }

    public void setSymKeyServerToClient(byte[] symKeyServerToClient) {
        this.symKeyServerToClient = symKeyServerToClient;
    }

    public void setClientHelloDataHash(byte[] clientHelloDataHash) {
        this.clientHelloDataHash = clientHelloDataHash;
    }

    public void setClientHelloDataCertificateHash(byte[] clientHelloDataCertificateHash) {
        this.clientHelloDataCertificateHash = clientHelloDataCertificateHash;
    }

    public void setServerHelloDataHash(byte[] serverHelloDataHash) {
        this.serverHelloDataHash = serverHelloDataHash;
    }

    public void setEphemeralKeyPair(KeyPair ephemeralKeyPair) {
        this.ephemeralKeyPair = ephemeralKeyPair;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public void setShare(byte[] share) {
        this.share = share;
    }

    public void setAuthzToken(byte[] authzToken) {
        this.authzToken = authzToken;
    }

    public void setRecordIDFromAuthzToken(String recordIDFromAuthzToken) {
        this.recordIDFromAuthzToken = recordIDFromAuthzToken;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public void setForceErrorInDecryptIfCountIs5(boolean forceErrorInDecryptIfCountIs5) {
        this.forceErrorInDecryptIfCountIs5 = forceErrorInDecryptIfCountIs5;
    }

    public void setForceErrorInEncryptIfCountIs6(boolean forceErrorInEncryptIfCountIs6) {
        this.forceErrorInEncryptIfCountIs6 = forceErrorInEncryptIfCountIs6;
    }

    public void setState(VAUProtocolSessionState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VAUProtocolSession)) {
            return false;
        }
        VAUProtocolSession other = (VAUProtocolSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getKeyID(), other.getKeyID())) {
            return false;
        }
        if (!Arrays.equals(this.getSymKeyClientToServer(), other.getSymKeyClientToServer())) {
            return false;
        }
        if (!Arrays.equals(this.getSymKeyServerToClient(), other.getSymKeyServerToClient())) {
            return false;
        }
        if (!Arrays.equals(this.getClientHelloDataHash(), other.getClientHelloDataHash())) {
            return false;
        }
        if (!Arrays.equals(this.getClientHelloDataCertificateHash(), other.getClientHelloDataCertificateHash())) {
            return false;
        }
        if (!Arrays.equals(this.getServerHelloDataHash(), other.getServerHelloDataHash())) {
            return false;
        }
        KeyPair this$ephemeralKeyPair = this.getEphemeralKeyPair();
        KeyPair other$ephemeralKeyPair = other.getEphemeralKeyPair();
        if (this$ephemeralKeyPair == null ? other$ephemeralKeyPair != null : !this$ephemeralKeyPair.equals(other$ephemeralKeyPair)) {
            return false;
        }
        if (!Arrays.equals(this.getHash(), other.getHash())) {
            return false;
        }
        if (!Arrays.equals(this.getShare(), other.getShare())) {
            return false;
        }
        if (!Arrays.equals(this.getAuthzToken(), other.getAuthzToken())) {
            return false;
        }
        String this$recordIDFromAuthzToken = this.getRecordIDFromAuthzToken();
        String other$recordIDFromAuthzToken = other.getRecordIDFromAuthzToken();
        if (this$recordIDFromAuthzToken == null ? other$recordIDFromAuthzToken != null : !this$recordIDFromAuthzToken.equals(other$recordIDFromAuthzToken)) {
            return false;
        }
        if (this.getCounter() != other.getCounter()) {
            return false;
        }
        if (this.isClient() != other.isClient()) {
            return false;
        }
        if (this.isForceErrorInDecryptIfCountIs5() != other.isForceErrorInDecryptIfCountIs5()) {
            return false;
        }
        if (this.isForceErrorInEncryptIfCountIs6() != other.isForceErrorInEncryptIfCountIs6()) {
            return false;
        }
        VAUProtocolSessionState this$state = this.getState();
        VAUProtocolSessionState other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VAUProtocolSession;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getKeyID());
        result = result * 59 + Arrays.hashCode(this.getSymKeyClientToServer());
        result = result * 59 + Arrays.hashCode(this.getSymKeyServerToClient());
        result = result * 59 + Arrays.hashCode(this.getClientHelloDataHash());
        result = result * 59 + Arrays.hashCode(this.getClientHelloDataCertificateHash());
        result = result * 59 + Arrays.hashCode(this.getServerHelloDataHash());
        KeyPair $ephemeralKeyPair = this.getEphemeralKeyPair();
        result = result * 59 + ($ephemeralKeyPair == null ? 43 : $ephemeralKeyPair.hashCode());
        result = result * 59 + Arrays.hashCode(this.getHash());
        result = result * 59 + Arrays.hashCode(this.getShare());
        result = result * 59 + Arrays.hashCode(this.getAuthzToken());
        String $recordIDFromAuthzToken = this.getRecordIDFromAuthzToken();
        result = result * 59 + ($recordIDFromAuthzToken == null ? 43 : $recordIDFromAuthzToken.hashCode());
        long $counter = this.getCounter();
        result = result * 59 + (int)($counter >>> 32 ^ $counter);
        result = result * 59 + (this.isClient() ? 79 : 97);
        result = result * 59 + (this.isForceErrorInDecryptIfCountIs5() ? 79 : 97);
        result = result * 59 + (this.isForceErrorInEncryptIfCountIs6() ? 79 : 97);
        VAUProtocolSessionState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        return result;
    }

    public String toString() {
        return "VAUProtocolSession(keyID=" + Arrays.toString(this.getKeyID()) + ", symKeyClientToServer=" + Arrays.toString(this.getSymKeyClientToServer()) + ", symKeyServerToClient=" + Arrays.toString(this.getSymKeyServerToClient()) + ", clientHelloDataHash=" + Arrays.toString(this.getClientHelloDataHash()) + ", clientHelloDataCertificateHash=" + Arrays.toString(this.getClientHelloDataCertificateHash()) + ", serverHelloDataHash=" + Arrays.toString(this.getServerHelloDataHash()) + ", ephemeralKeyPair=" + this.getEphemeralKeyPair() + ", hash=" + Arrays.toString(this.getHash()) + ", share=" + Arrays.toString(this.getShare()) + ", authzToken=" + Arrays.toString(this.getAuthzToken()) + ", recordIDFromAuthzToken=" + this.getRecordIDFromAuthzToken() + ", counter=" + this.getCounter() + ", client=" + this.isClient() + ", forceErrorInDecryptIfCountIs5=" + this.isForceErrorInDecryptIfCountIs5() + ", forceErrorInEncryptIfCountIs6=" + this.isForceErrorInEncryptIfCountIs6() + ", state=" + this.getState() + ")";
    }

    public VAUProtocolSession(byte[] keyID, byte[] symKeyClientToServer, byte[] symKeyServerToClient, byte[] clientHelloDataHash, byte[] clientHelloDataCertificateHash, byte[] serverHelloDataHash, KeyPair ephemeralKeyPair, byte[] hash, byte[] share, byte[] authzToken, String recordIDFromAuthzToken, long counter, boolean client, boolean forceErrorInDecryptIfCountIs5, boolean forceErrorInEncryptIfCountIs6, VAUProtocolSessionState state) {
        this.keyID = keyID;
        this.symKeyClientToServer = symKeyClientToServer;
        this.symKeyServerToClient = symKeyServerToClient;
        this.clientHelloDataHash = clientHelloDataHash;
        this.clientHelloDataCertificateHash = clientHelloDataCertificateHash;
        this.serverHelloDataHash = serverHelloDataHash;
        this.ephemeralKeyPair = ephemeralKeyPair;
        this.hash = hash;
        this.share = share;
        this.authzToken = authzToken;
        this.recordIDFromAuthzToken = recordIDFromAuthzToken;
        this.counter = counter;
        this.client = client;
        this.forceErrorInDecryptIfCountIs5 = forceErrorInDecryptIfCountIs5;
        this.forceErrorInEncryptIfCountIs6 = forceErrorInEncryptIfCountIs6;
        this.state = state;
    }

    public static class VAUProtocolSessionBuilder {
        private byte[] keyID;
        private byte[] symKeyClientToServer;
        private byte[] symKeyServerToClient;
        private byte[] clientHelloDataHash;
        private byte[] clientHelloDataCertificateHash;
        private byte[] serverHelloDataHash;
        private KeyPair ephemeralKeyPair;
        private byte[] hash;
        private byte[] share;
        private byte[] authzToken;
        private String recordIDFromAuthzToken;
        private long counter;
        private boolean client;
        private boolean forceErrorInDecryptIfCountIs5;
        private boolean forceErrorInEncryptIfCountIs6;
        private VAUProtocolSessionState state;

        VAUProtocolSessionBuilder() {
        }

        public VAUProtocolSessionBuilder keyID(byte[] keyID) {
            this.keyID = keyID;
            return this;
        }

        public VAUProtocolSessionBuilder symKeyClientToServer(byte[] symKeyClientToServer) {
            this.symKeyClientToServer = symKeyClientToServer;
            return this;
        }

        public VAUProtocolSessionBuilder symKeyServerToClient(byte[] symKeyServerToClient) {
            this.symKeyServerToClient = symKeyServerToClient;
            return this;
        }

        public VAUProtocolSessionBuilder clientHelloDataHash(byte[] clientHelloDataHash) {
            this.clientHelloDataHash = clientHelloDataHash;
            return this;
        }

        public VAUProtocolSessionBuilder clientHelloDataCertificateHash(byte[] clientHelloDataCertificateHash) {
            this.clientHelloDataCertificateHash = clientHelloDataCertificateHash;
            return this;
        }

        public VAUProtocolSessionBuilder serverHelloDataHash(byte[] serverHelloDataHash) {
            this.serverHelloDataHash = serverHelloDataHash;
            return this;
        }

        public VAUProtocolSessionBuilder ephemeralKeyPair(KeyPair ephemeralKeyPair) {
            this.ephemeralKeyPair = ephemeralKeyPair;
            return this;
        }

        public VAUProtocolSessionBuilder hash(byte[] hash) {
            this.hash = hash;
            return this;
        }

        public VAUProtocolSessionBuilder share(byte[] share) {
            this.share = share;
            return this;
        }

        public VAUProtocolSessionBuilder authzToken(byte[] authzToken) {
            this.authzToken = authzToken;
            return this;
        }

        public VAUProtocolSessionBuilder recordIDFromAuthzToken(String recordIDFromAuthzToken) {
            this.recordIDFromAuthzToken = recordIDFromAuthzToken;
            return this;
        }

        public VAUProtocolSessionBuilder counter(long counter) {
            this.counter = counter;
            return this;
        }

        public VAUProtocolSessionBuilder client(boolean client) {
            this.client = client;
            return this;
        }

        public VAUProtocolSessionBuilder forceErrorInDecryptIfCountIs5(boolean forceErrorInDecryptIfCountIs5) {
            this.forceErrorInDecryptIfCountIs5 = forceErrorInDecryptIfCountIs5;
            return this;
        }

        public VAUProtocolSessionBuilder forceErrorInEncryptIfCountIs6(boolean forceErrorInEncryptIfCountIs6) {
            this.forceErrorInEncryptIfCountIs6 = forceErrorInEncryptIfCountIs6;
            return this;
        }

        public VAUProtocolSessionBuilder state(VAUProtocolSessionState state) {
            this.state = state;
            return this;
        }

        public VAUProtocolSession build() {
            return new VAUProtocolSession(this.keyID, this.symKeyClientToServer, this.symKeyServerToClient, this.clientHelloDataHash, this.clientHelloDataCertificateHash, this.serverHelloDataHash, this.ephemeralKeyPair, this.hash, this.share, this.authzToken, this.recordIDFromAuthzToken, this.counter, this.client, this.forceErrorInDecryptIfCountIs5, this.forceErrorInEncryptIfCountIs6, this.state);
        }

        public String toString() {
            return "VAUProtocolSession.VAUProtocolSessionBuilder(keyID=" + Arrays.toString(this.keyID) + ", symKeyClientToServer=" + Arrays.toString(this.symKeyClientToServer) + ", symKeyServerToClient=" + Arrays.toString(this.symKeyServerToClient) + ", clientHelloDataHash=" + Arrays.toString(this.clientHelloDataHash) + ", clientHelloDataCertificateHash=" + Arrays.toString(this.clientHelloDataCertificateHash) + ", serverHelloDataHash=" + Arrays.toString(this.serverHelloDataHash) + ", ephemeralKeyPair=" + this.ephemeralKeyPair + ", hash=" + Arrays.toString(this.hash) + ", share=" + Arrays.toString(this.share) + ", authzToken=" + Arrays.toString(this.authzToken) + ", recordIDFromAuthzToken=" + this.recordIDFromAuthzToken + ", counter=" + this.counter + ", client=" + this.client + ", forceErrorInDecryptIfCountIs5=" + this.forceErrorInDecryptIfCountIs5 + ", forceErrorInEncryptIfCountIs6=" + this.forceErrorInEncryptIfCountIs6 + ", state=" + this.state + ")";
        }
    }
}

