/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol;

import de.gematik.ti.vauchannel.protocol.VAUProtocolSession;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.crypto.DataLengthException;

public interface VAUProtocolCrypto {
    public LocalDateTime now();

    public byte[] hash(byte[] var1);

    public byte[] ECKA(PrivateKey var1, PublicKey var2) throws Exception;

    public byte[] HKDF(byte[] var1, String var2, int var3) throws IllegalArgumentException, DataLengthException;

    public byte[] HKDF(byte[] var1, byte[] var2, int var3) throws IllegalArgumentException, DataLengthException;

    public byte[] signRSASSA_PSS(byte[] var1) throws Exception;

    public boolean verify(byte[] var1, byte[] var2, PublicKey var3);

    public byte[] signECDSA(byte[] var1) throws Exception;

    public KeyPair generateECCKeyPair();

    public PublicKey eccPublicKeyFromBytes(byte[] var1);

    public OCSPResp getOcspResponse();

    public X509Certificate getEECertificate();

    public boolean isECCIdentity();

    public boolean canProvideOcspResponse();

    public byte[] encrypt_AESGCM(byte[] var1, byte[] var2, long var3) throws Exception;

    public byte[] decrypt_AESGCM(byte[] var1, byte[] var2, long var3) throws Exception;

    public void validateAuthorizationAssertion(VAUProtocolSession var1, String var2);

    public void checkServerCertificate(X509Certificate var1);

    public void performOcspCheckForCertificate(X509Certificate var1) throws Exception;

    public void performTslCheckForCertificate(X509Certificate var1) throws Exception;
}

