/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.vauchannel.protocol;

import com.google.common.base.Charsets;
import de.gematik.ti.vauchannel.protocol.VAUProtocolException;
import de.gematik.ti.vauchannel.protocol.helpers.VAUProtocolHelpers;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportedData {
    private static final Logger log = LoggerFactory.getLogger(TransportedData.class);
    public byte[] body;
    public String contentType;
    static final String contentTypeDefault = "application/soap+xml";

    public TransportedData() {
    }

    public TransportedData(byte[] body, String contentType) {
        this.body = body;
        this.contentType = contentType;
        this.log();
    }

    public static TransportedData fromRaw(byte[] raw) {
        byte[] numberOfBytes_inBytes = new byte[4];
        System.arraycopy(raw, 0, numberOfBytes_inBytes, 0, 4);
        int numberOfBytes = ByteBuffer.wrap(numberOfBytes_inBytes).getInt();
        byte[] headerField_inBytes = new byte[numberOfBytes];
        System.arraycopy(raw, 4, headerField_inBytes, 0, numberOfBytes);
        String headerField = new String(headerField_inBytes, Charsets.US_ASCII);
        int i = headerField.indexOf(":");
        String value = contentTypeDefault;
        if (i > -1) {
            value = headerField.substring(i + 1, headerField.length()).trim();
            String key = headerField.substring(0, i);
            if (!key.equalsIgnoreCase("Content-Type")) {
                throw new VAUProtocolException("message syntax not correct");
            }
            log.debug("the following content-type header was transported inside the VAU channel: " + key + ": " + value);
        } else {
            log.debug("default content-type header is restored.");
        }
        TransportedData td = new TransportedData();
        td.contentType = value;
        td.body = new byte[raw.length - 4 - numberOfBytes];
        System.arraycopy(raw, 4 + numberOfBytes, td.body, 0, td.body.length);
        td.log();
        return td;
    }

    public byte[] getRaw() {
        Object headerField = "";
        if (!this.contentType.equals(contentTypeDefault)) {
            headerField = "Content-Type: " + this.contentType;
        }
        byte[] headerField_inBytes = ((String)headerField).getBytes(Charsets.US_ASCII);
        byte[] numberOfBytes_inBytes = ByteBuffer.allocate(4).putInt(headerField_inBytes.length).array();
        return VAUProtocolHelpers.concat(VAUProtocolHelpers.concat(numberOfBytes_inBytes, headerField_inBytes), this.body);
    }

    public void log() {
        log.info("contentType: " + this.contentType + "; body length: " + this.body.length);
        log.debug(new String(this.body, Charsets.UTF_8));
    }
}

