/*
 * Copyright (c) 2020 gematik GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.gematik.ti.healthcard.control.entities.card.certificate;

import java.security.cert.X509Certificate;

import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.gematik.ti.utils.codec.Hex;

/**
 * TODO: move to TIUTILS
  */
public class CertificateUtilTest {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateUtilTest.class);

    @Test
    public void testGetActorNameHbaElc() {
        String stringCert = "308203B73082035DA003020102020702EBFC3A4CB69E300A06082A8648CE3D040302308189310B3009060355040613024445311F301D060355040A0C1667656D6174696B20476D6248204E4F542D56414C494431383036060355040B0C2F4865696C626572756673617573776569732D4341206465722054656C656D6174696B696E667261737472756B747572311F301D06035504030C1647454D2E4842412D4341313320544553542D4F4E4C59301E170D3138313031313030303030305A170D3230313031303233353935395A3075310B30090603550406130244453166300E060355042A0C074C756B61732079301306035504040C0C4E69C3B16F2047C3B46D657A301B060355040513143830323736383833313130303030323035363930302206035504030C1B4C756B6173204E69C3B16F2047C3B46D657A544553542D4F4E4C59305A301406072A8648CE3D020106092B240303020801010703420004A3084FAAF2B233472183AB30098EF3D4E41991C3B7391B979C21124B2CCD0852A948B27FB58B4916FBB187FA92315B188964FA3FDBB56FA14A3B7B2548B0A00FA38201C0308201BC301D0603551D0E041604149FBCE2C728716114160EA592CCA43E73C6EEDEBD300C0603551D130101FF04023000301D0603551D250416301406082B0601050507030206082B06010505070304307D06052B2408030304743072A42C302A310B3009060355040613024445311B3019060355040A0C124C616E646573C3A4727A74656B616D6D657230423040303E303C300E0C0CC384727A74696E2F41727A74300906072A8214004C041E131F312D4842412D546573746B617274652D383833313130303030323035363930301F0603551D230418301680144F9B34C24FC9AA985B516F767916A3B882C8CBC230710603551D20046A3068300906072A8214004C044B300C060A2B0601040182CD330101304D06082A8214004C0481113041303F06082B060105050702011633687474703A2F2F7777772E652D61727A74617573776569732E64652F706F6C69636965732F45455F706F6C6963792E68746D6C300E0603551D0F0101FF040403020388304B06082B06010505070101043F303D303B06082B06010505073001862F687474703A2F2F6F6373702E706B692E74656C656D6174696B2D746573743A383038302F434D4F4353502F4F435350300A06082A8648CE3D040302034800304502210081BAF3945761D35B0FB9728DEA7ECE296967658A38D757C749652D7D8602D153022077EDC28572EDC164DC28F86E588CEF0F234CD8492FF8BA1597606F4C60F8FA20";
        byte[] bytes = Hex.decode(stringCert);
        X509Certificate certificate = CertificateUtil.getCertificate(bytes);

        String result = CertificateUtil.getSurnameGivenname(certificate);
        Assert.assertThat(result, Is.is("(Niño Gômez, Lukas y)"));
    }

    @Test
    public void testGetActorNameHbaRsa() {
        String stringCert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
        byte[] bytes = Hex.decode(stringCert);
        X509Certificate certificate = CertificateUtil.getCertificate(bytes);

        String result = CertificateUtil.getSurnameGivenname(certificate);
        Assert.assertThat(result, Is.is("(Niño Gômez, Lukas y)"));

        //
        stringCert = "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";
        bytes = Hex.decode(stringCert);
        certificate = CertificateUtil.getCertificate(bytes);

        result = CertificateUtil.getSurnameGivenname(certificate);
        Assert.assertThat(result, Is.is("(Goerlitzer, Ullrich)"));
    }

    @Test
    public void testGetActorNameSmcbElc() {
        String stringCert = "308203B030820356A003020102020703EB30E4DF8A09300A06082A8648CE3D040302308199310B3009060355040613024445311F301D060355040A0C1667656D6174696B20476D6248204E4F542D56414C494431483046060355040B0C3F496E737469747574696F6E2064657320476573756E646865697473776573656E732D4341206465722054656C656D6174696B696E667261737472756B747572311F301D06035504030C1647454D2E534D43422D43413920544553542D4F4E4C59301E170D3139303730333030303030305A170D3234303730323233353935395A3081D8310B30090603550406130244453110300E06035504070C07526F73746F636B310E300C06035504110C0531383035393118301606035504090C0F52656E6E6261686E616C6C65652031312A3028060355040A0C21332D534D432D422D546573746B617274652D383833313130303030323132353633311D301B0603550405131438303237363838333131303030303231323536333110300E06035504040C0742757267756E64310F300D060355042A0C06526F6C616E64311F301D06035504030C164E6F72642041706F7468656B65544553542D4F4E4C59305A301406072A8648CE3D020106092B24030302080101070342000437526F36D55D68CB725E8231A4187CDCADA101624127B709A482ECB131731127A02FBCEE6B26F6C12A6C9864162C877C8F93985C17FDC7C5E512DB4FF3B4E7FBA382014530820141301D0603551D0E041604143B7B522C15A6D392FC55EDCE8992C99EFC1E7D64300E0603551D0F0101FF04040302064030200603551D2004193017300A06082A8214004C048123300906072A8214004C044E300C0603551D130101FF04023000301F0603551D23041830168014BDC0DFB570A73BE47451422A3CDDCCDD9F0136C3303806082B06010505070101042C302A302806082B06010505073001861C687474703A2F2F656863612E67656D6174696B2E64652F6F6373702F30818406052B24080303047B3079A4283026310B300906035504061302444531173015060355040A0C0E67656D6174696B204265726C696E304D304B3049304730170C15C3966666656E746C696368652041706F7468656B65300906072A8214004C04361321332D534D432D422D546573746B617274652D383833313130303030323132353633300A06082A8648CE3D040302034800304502210089AD031FF4B29429B23DD68218F91D27735C9CA16A3A5B35AC061FBC6D2C8D5302202919CE386499865358B1F26AA722C1AC4B1BCABDFC7105A5FCC0E49A57D35A9B";
        byte[] bytes = Hex.decode(stringCert);
        X509Certificate certificate = CertificateUtil.getCertificate(bytes);

        String result = CertificateUtil.getCommonName(certificate);
        Assert.assertThat(result, Is.is("GEM.SMCB-CA9 TEST-ONLY"));
    }

    @Test
    public void testGetActorNameSmacbRsa() {
        String stringCert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
        byte[] bytes = Hex.decode(stringCert);
        X509Certificate certificate = CertificateUtil.getCertificate(bytes);

        String result = CertificateUtil.getCommonName(certificate);
        Assert.assertThat(result, Is.is("GEM.SMCB-CA4 TEST-ONLY"));
    }
}
