/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.service.localization;

import de.gematik.ti.epa.fdv.service.localization.GatewayModulePathType;
import de.gematik.ti.epa.fdv.service.localization.api.LookupStatus;
import de.gematik.ti.epa.fdv.service.localization.api.ServiceInterfaceName;
import de.gematik.ti.epa.fdv.service.localization.exceptions.ServiceLocatorException;
import de.gematik.ti.epa.fdv.service.localization.spi.IServiceLocalizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public final class ServiceLocator
implements IServiceLocalizer {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLocator.class);
    private static final String SCHEME = "https://";
    private static final int PORT = 443;
    private String fqdn;
    private boolean running = false;
    private LookupStatus lookupStatus = LookupStatus.NOT_STARTED;
    private final Map<String, GatewayModulePathType> dnsTxtRecordValues = new HashMap<String, GatewayModulePathType>();

    public void lookup(String fqdn, Consumer<LookupStatus> callback) {
        Record[] records;
        if (this.running) {
            return;
        }
        this.running = true;
        this.dnsTxtRecordValues.clear();
        this.fqdn = fqdn;
        try {
            Lookup lookup = new Lookup(fqdn, 16);
            records = lookup.run();
        }
        catch (TextParseException e) {
            this.lookupStatus = LookupStatus.ERROR;
            throw new RuntimeException(e);
        }
        if (records != null) {
            this.fillDnsTxtRecordValues(records);
        } else {
            this.lookupStatus = LookupStatus.MISSING_TXT_RECORD;
        }
        this.running = false;
        callback.accept(this.lookupStatus);
    }

    public URL endpointURLForInterface(ServiceInterfaceName serviceInterfaceName) {
        boolean isValid = this.handleTTL(serviceInterfaceName.getModuleName());
        if (this.lookupStatus.equals((Object)LookupStatus.SUCCESS) && isValid) {
            String path = this.dnsTxtRecordValues.get(serviceInterfaceName.getModuleName()).getPath();
            try {
                URL url = serviceInterfaceName.getServiceLocatorName().length() > 0 ? new URL(SCHEME + this.fqdn + ":" + 443 + path + serviceInterfaceName.getServiceLocatorName()) : new URL(SCHEME + this.fqdn + ":" + 443 + path);
                LOG.debug("endpointURLForInterface for Interface " + serviceInterfaceName.getServiceLocatorName() + ": " + url);
                return url;
            }
            catch (MalformedURLException e) {
                LOG.error("Malformed URL received from module " + path + e.getMessage());
            }
        }
        return null;
    }

    void fillDnsTxtRecordValues(Record[] records) {
        for (Record record : records) {
            String rData = record.rdataToString().replaceAll("\"", "");
            List<String> rDataTokens = Arrays.asList(rData.split("\\s+"));
            TXTRecord txtRecord = new TXTRecord(record.getName(), record.getDClass(), record.getTTL(), rDataTokens);
            List recordStrings = txtRecord.getStrings();
            if (recordStrings == null || recordStrings.isEmpty()) continue;
            for (String string : recordStrings) {
                if (!string.contains("=")) continue;
                String[] splitToken = string.trim().split("=", 2);
                this.fillModuleList(record, splitToken);
            }
        }
        this.lookupStatus = this.dnsTxtRecordValues.size() > 0 ? LookupStatus.SUCCESS : LookupStatus.MISSING_TXT_RECORD;
    }

    private void fillModuleList(Record record, String[] splitToken) {
        if (splitToken.length == 2) {
            String txtRecordName = splitToken[0];
            if (txtRecordName.equals("txtvers")) {
                this.checkTxtVersion(splitToken[1]);
            } else {
                GatewayModulePathType gatewayModulePathType = new GatewayModulePathType(splitToken[1], record.getTTL());
                this.dnsTxtRecordValues.put(splitToken[0], gatewayModulePathType);
                LOG.debug("TxtRecordName: " + txtRecordName + " gatewayModulePath: " + gatewayModulePathType.getPath() + " valid until: " + gatewayModulePathType.getValidUntil().toString());
            }
        }
    }

    private void checkTxtVersion(String version) {
        if (!"1".equals(version)) {
            throw new ServiceLocatorException("Wrong txtVersion in DNS Response found.");
        }
    }

    public LookupStatus getLookupStatus() {
        if (!this.running) {
            return this.lookupStatus;
        }
        return LookupStatus.IN_PROGRESS;
    }

    public String getHomeCommunityId() {
        boolean isValid = this.handleTTL("hcid");
        if (isValid) {
            return this.dnsTxtRecordValues.get("hcid").getPath();
        }
        return null;
    }

    private boolean handleTTL(String txtRecordName) {
        Date validUntil = this.dnsTxtRecordValues.get(txtRecordName).getValidUntil();
        return validUntil.getTime() >= new Date(System.currentTimeMillis()).getTime();
    }
}

