/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication.transport;

import de.gematik.ti.epa.fdv.authentication.serialization.KxmlSerializerWithPreMarshalledXmlWriter;
import de.gematik.ti.epa.fdv.gen.authentication.ExtendedSoapSerializationEnvelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ksoap2.HeaderProperty;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.transport.ServiceConnection;
import org.ksoap2.transport.Transport;
import org.xmlpull.v1.XmlSerializer;

public class SoapDataDelegate
extends Transport {
    private static final int DEFAULT_CONTENT_LENGTH = 262144;
    private static final int BUFFER_LENGTH = 256;
    private String xmlVersionTag = "";
    private String responseString;

    public void setXmlVersionTag(String tag) {
        this.xmlVersionTag = tag;
    }

    public List call(String s, SoapEnvelope soapEnvelope, List list) {
        return null;
    }

    public List call(String s, SoapEnvelope soapEnvelope, List list, File file) {
        return null;
    }

    public ServiceConnection getServiceConnection() {
        return null;
    }

    byte[] createRequestData(SoapEnvelope envelope, String encoding, Map prefixes) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(262144);){
            bos.write(this.xmlVersionTag.getBytes());
            KxmlSerializerWithPreMarshalledXmlWriter xw = new KxmlSerializerWithPreMarshalledXmlWriter();
            Iterator keysIter = prefixes.keySet().iterator();
            xw.setOutput(bos, encoding);
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                xw.setPrefix(key, (String)prefixes.get(key));
            }
            envelope.write((XmlSerializer)xw);
            xw.flush();
            bos.write(13);
            bos.write(10);
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    InputStream parseResponse(InputStream is, List returnedHeaders) throws IOException {
        this.responseString = null;
        Charset charset = this.getCharset(returnedHeaders);
        int contentLength = this.getContentLength(returnedHeaders);
        return this.readInput(is, contentLength, charset);
    }

    private Charset getCharset(List returnedHeaders) {
        Charset charset = null;
        if (!returnedHeaders.isEmpty()) {
            for (Object returnedHeader : returnedHeaders) {
                HeaderProperty hp = (HeaderProperty)returnedHeader;
                if (hp.getKey() == null || !"Content-Type".equalsIgnoreCase(hp.getKey())) continue;
                String contentType = hp.getValue().toLowerCase();
                if (contentType.contains("utf-8")) {
                    charset = StandardCharsets.UTF_8;
                    continue;
                }
                if (!contentType.contains("utf-16")) continue;
                charset = StandardCharsets.UTF_16;
            }
        }
        return charset;
    }

    private int getContentLength(List returnedHeaders) {
        int contentLength = 0;
        if (!returnedHeaders.isEmpty()) {
            for (Object returnedHeader : returnedHeaders) {
                HeaderProperty hp = (HeaderProperty)returnedHeader;
                if (hp.getKey() == null || !"content-length".equalsIgnoreCase(hp.getKey())) continue;
                contentLength = Integer.parseInt(hp.getValue());
            }
        }
        return contentLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream readInput(InputStream is, int contentLength, Charset charset) throws IOException {
        byte[] buf = new byte[256];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(contentLength > 0 ? contentLength : 262144);){
            while (true) {
                int rd;
                if ((rd = is.read(buf, 0, 256)) == -1) {
                    bos.flush();
                    buf = bos.toByteArray();
                    this.readEncodedResponseString(charset, buf);
                    is.close();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
                    return byteArrayInputStream;
                }
                bos.write(buf, 0, rd);
                continue;
                break;
            }
        }
    }

    private void readEncodedResponseString(Charset charset, byte[] buf) {
        this.responseString = charset != null ? new String(buf, charset) : new String(buf);
    }

    public String getResponseString() {
        return this.responseString;
    }

    public byte[] generateRequestData(ExtendedSoapSerializationEnvelope envelope) throws IOException {
        return super.createRequestData((SoapEnvelope)envelope, "UTF-8");
    }
}

