/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication.states;

import de.gematik.ti.epa.fdv.authentication.exceptions.AuthenticateException;
import de.gematik.ti.epa.fdv.gen.authentication.RequestSecurityTokenResponseType;
import de.gematik.ti.healthcardaccess.operation.Result;
import org.ksoap2.serialization.PropertyInfo;

public enum LogoutTokenState {
    LOGOUT_TOKEN_SUCCESS,
    LOGOUT_TOKEN_FAILED;


    public static LogoutTokenState getState(RequestSecurityTokenResponseType response) {
        try {
            PropertyInfo canceledPi = (PropertyInfo)response.any.get(0);
            String piName = canceledPi.name;
            if ("RequestedTokenCancelled".equals(piName)) {
                return LOGOUT_TOKEN_SUCCESS;
            }
        }
        catch (Exception e) {
            throw new AuthenticateException("Logout token failed" + e);
        }
        return LOGOUT_TOKEN_FAILED;
    }

    public Result<LogoutTokenState> validateState(LogoutTokenState state) {
        if (this == state) {
            return Result.success((Object)((Object)state));
        }
        return Result.failure((Throwable)new AuthenticateException(String.format("LogoutTokenState: expected state: %s, but was: %s", new Object[]{this, state})));
    }
}

