/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication.soap;

import de.gematik.ti.epa.fdv.authentication.security.Namespaces;
import de.gematik.ti.epa.fdv.gen.authentication.ExtendedSoapSerializationEnvelope;
import java.io.IOException;
import java.util.UUID;
import org.xmlpull.v1.XmlSerializer;

public class ExpandedSoapSerializationEnvelope
extends ExtendedSoapSerializationEnvelope {
    private static final String XSI_URL = Namespaces.XSI.getNamespaceUrl();
    private static final String XSD_URL = Namespaces.XSD.getNamespaceUrl();
    private static final String ENC_URL = Namespaces.ENC.getNamespaceUrl();
    private static final String XML_URL = Namespaces.XML.getNamespaceUrl();
    private static final String SAML2_URL = Namespaces.SAML_2.getNamespaceUrl();
    private static final String WSU_URL = Namespaces.WSU.getNamespaceUrl();
    private static final String ENVELOPE = "Envelope";
    private static final String HEADER = "Header";
    private static final String BODY = "Body";
    private UUID uuid = null;

    public ExpandedSoapSerializationEnvelope(int version) {
        super(version);
        this.createClassesForAny = true;
        this.implicitTypes = true;
    }

    public void write(XmlSerializer writer) throws IOException {
        writer.setPrefix("xsi", XSI_URL);
        writer.setPrefix("xsd", XSD_URL);
        writer.setPrefix("enc", ENC_URL);
        writer.setPrefix("soap", this.env);
        writer.setPrefix("xml", XML_URL);
        writer.setPrefix("saml2", SAML2_URL);
        this.setNSPrefix(writer, Namespaces.WSU);
        this.setNSPrefix(writer, Namespaces.DS);
        this.setNSPrefix(writer, Namespaces.WSSE);
        this.setNSPrefix(writer, Namespaces.TRUST);
        this.setNSPrefix(writer, Namespaces.SAML_2);
        writer.startTag(this.env, ENVELOPE);
        writer.startTag(this.env, HEADER);
        this.writeHeader(writer);
        writer.endTag(this.env, HEADER);
        writer.startTag(this.env, BODY);
        if (this.uuid != null) {
            writer.attribute(WSU_URL, "Id", "id-" + this.uuid.toString());
        }
        this.writeBody(writer);
        writer.endTag(this.env, BODY);
        writer.endTag(this.env, ENVELOPE);
    }

    private void setNSPrefix(XmlSerializer writer, Namespaces ns) throws IOException {
        writer.setPrefix(ns.name(), ns.getNamespaceUrl());
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }
}

