/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication.serialization;

import de.gematik.ti.epa.fdv.authentication.serialization.IPreMarshalledXmlSerializable;
import de.gematik.ti.epa.fdv.authentication.serialization.PreMarshalledElement;
import de.gematik.ti.epa.fdv.gen.authentication.Helper;
import java.util.Date;
import java.util.Hashtable;
import org.ksoap2.serialization.AttributeContainer;
import org.ksoap2.serialization.AttributeInfo;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapPrimitive;
import org.kxml2.kdom.Element;

public final class HeaderConverter {
    private HeaderConverter() {
    }

    public static Element convertToHeader(Object headerElement, String namespace, String name) {
        Element parentElement = new Element().createElement(namespace, name);
        if (headerElement == null) {
            return parentElement;
        }
        if (headerElement instanceof IPreMarshalledXmlSerializable) {
            PreMarshalledElement element = new PreMarshalledElement();
            element.setPreMarshalledXml(headerElement.toString());
            return element;
        }
        if (headerElement instanceof KvmSerializable) {
            KvmSerializable soapObject = (KvmSerializable)headerElement;
            HeaderConverter.convertKvmSerializableElement(parentElement, soapObject);
        } else if (headerElement != SoapPrimitive.NullSkip && headerElement != SoapPrimitive.NullNilElement) {
            HeaderConverter.createDateElement(headerElement, parentElement);
        }
        if (headerElement instanceof AttributeContainer) {
            HeaderConverter.convertAttributeContainerElement((AttributeContainer)headerElement, parentElement);
        }
        return parentElement;
    }

    private static void convertKvmSerializableElement(Element parentElement, KvmSerializable soapObject) {
        for (int i = 0; i < soapObject.getPropertyCount(); ++i) {
            PropertyInfo info = new PropertyInfo();
            soapObject.getPropertyInfo(i, new Hashtable(), info);
            Object value = soapObject.getProperty(i);
            if (value == null || value == SoapPrimitive.NullSkip || value == SoapPrimitive.NullNilElement) continue;
            info.setValue(value);
            Element el1 = HeaderConverter.convertToHeader(info.getValue(), info.getNamespace(), info.getName());
            parentElement.addChild(2, (Object)el1);
        }
    }

    private static void convertAttributeContainerElement(AttributeContainer headerElement, Element parentElement) {
        AttributeContainer attrContainer = headerElement;
        for (int i = 0; i < attrContainer.getAttributeCount(); ++i) {
            AttributeInfo info = new AttributeInfo();
            attrContainer.getAttributeInfo(i, info);
            Object value = info.getValue();
            String valueString = "";
            if (value != null) {
                valueString = value.toString();
            }
            parentElement.setAttribute(info.namespace, info.name, valueString);
        }
    }

    private static void createDateElement(Object headerElement, Element parentElement) {
        String value = headerElement.toString();
        if (headerElement instanceof Date) {
            Date date = (Date)headerElement;
            value = Helper.getDateFormat().format(date);
        }
        parentElement.addChild(4, (Object)value);
    }
}

