/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication.serialization;

import de.gematik.ti.epa.fdv.authentication.AuthenticationBindingSoap;
import de.gematik.ti.epa.fdv.authentication.exceptions.AuthenticateException;
import de.gematik.ti.epa.fdv.authentication.security.ExtendedDigesterOutputStream;
import de.gematik.ti.epa.fdv.authentication.security.Namespaces;
import de.gematik.ti.epa.fdv.authentication.serialization.PreMarshalledPrimitive;
import de.gematik.ti.epa.fdv.authentication.service.provider.api.IAuthenticationResult;
import de.gematik.ti.epa.fdv.authentication.service.provider.api.IAuthenticator;
import de.gematik.ti.epa.fdv.authentication.soap.BinarySecurityTokenTypeWithId;
import de.gematik.ti.epa.fdv.authentication.soap.ExpandedSoapSerializationEnvelope;
import de.gematik.ti.epa.fdv.authentication.soap.ExtendedSignatureValueType;
import de.gematik.ti.epa.fdv.authentication.soap.SignatureInfoSignature;
import de.gematik.ti.epa.fdv.authentication.soap.SignatureTypeWithSignedInfoString;
import de.gematik.ti.epa.fdv.gen.authentication.KeyInfoType;
import de.gematik.ti.epa.fdv.gen.authentication.ReferenceType_2;
import de.gematik.ti.epa.fdv.gen.authentication.RequestSecurityTokenResponseType;
import de.gematik.ti.epa.fdv.gen.authentication.RequestSecurityTokenType;
import de.gematik.ti.epa.fdv.gen.authentication.SecurityHeaderType;
import de.gematik.ti.epa.fdv.gen.authentication.SecurityTokenReferenceType;
import de.gematik.ti.epa.fdv.gen.authentication.SignChallengeType;
import de.gematik.ti.utils.codec.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashSet;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverXPointer;
import org.ksoap2.serialization.PropertyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class AuthnSerializationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthnSerializationUtils.class);
    private static final String BEGIN_ASSERTION = "<saml2:Assertion";
    private static final String END_ASSERTION = "</saml2:Assertion>";

    private AuthnSerializationUtils() {
    }

    public static RequestSecurityTokenResponseType createRstrForLoginCreateToken(String challenge) {
        RequestSecurityTokenResponseType rstr = new RequestSecurityTokenResponseType();
        SignChallengeType signChallengeType = new SignChallengeType();
        signChallengeType.Challenge = challenge;
        PropertyInfo signChallengeResponse = AuthnSerializationUtils.createPropertyInfo("SignChallengeResponse", Namespaces.TRUST.getNamespaceUrl(), signChallengeType);
        rstr.any.add(signChallengeResponse);
        return rstr;
    }

    public static Document createDocFromRstr(RequestSecurityTokenResponseType rstr, AuthenticationBindingSoap service) {
        service.setShouldSendRequest(false);
        ExpandedSoapSerializationEnvelope envelope = (ExpandedSoapSerializationEnvelope)service.createEnvelope();
        envelope.addMapping(Namespaces.TRUST.getNamespaceUrl(), "RequestSecurityTokenResponse", RequestSecurityTokenResponseType.class);
        envelope.bodyOut = rstr;
        envelope.setOutputSoapObject(rstr);
        service.setShouldSendRequest(false);
        service.sendRequest(Namespaces.CREATE_TOKEN.getNamespaceUrl(), envelope, null, null);
        String request = new String(service.getRequestData());
        return AuthnSerializationUtils.createDocumentFromString(request);
    }

    public static SecurityHeaderType createSecurityHeader(SignatureInfoSignature signature, byte[] certificate) {
        String tokenIdString = "x509-" + UUID.randomUUID().toString();
        SecurityHeaderType securityHeader = new SecurityHeaderType();
        PropertyInfo binarySecurityTokenProperty = AuthnSerializationUtils.createBinarySecurityTokenProperty(certificate, tokenIdString);
        securityHeader.any.add(binarySecurityTokenProperty);
        PropertyInfo signatureProperty = AuthnSerializationUtils.createSignatureProperty(signature.getSignedInfoString(), signature.getSignatureInfoDigest(), tokenIdString);
        securityHeader.any.add(signatureProperty);
        return securityHeader;
    }

    public static String extractChallengeValue(RequestSecurityTokenResponseType requestSecurityTokenResponseType) {
        PropertyInfo propertyInfo = (PropertyInfo)requestSecurityTokenResponseType.any.get(0);
        SignChallengeType signChallengeType = (SignChallengeType)propertyInfo.getValue();
        return signChallengeType.Challenge;
    }

    public static SignatureInfoSignature signDocument(Document docToSign, IAuthenticator authenticationProvider, String sigAlgorithm, String uuid) {
        SignatureInfoSignature signedSignatureInfo;
        System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
        Init.init();
        try {
            ((Element)docToSign.getElementsByTagName("soap:Body").item(0)).setIdAttribute("wsu:Id", true);
            XMLSignature sig = new XMLSignature(docToSign, "", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/10/xml-exc-c14n#");
            docToSign.getElementsByTagName("soap:Header").item(0).appendChild(sig.getElement());
            SignedInfo signedInfo = sig.getSignedInfo();
            SignatureAlgorithm signatureAlgorithm = AuthnSerializationUtils.setupSignatureAlgorithm(sig, signedInfo, sigAlgorithm, uuid);
            MessageDigestAlgorithm digestAlgorithm = MessageDigestAlgorithm.getInstance((Document)docToSign, (String)"http://www.w3.org/2001/04/xmlenc#sha256");
            try (ExtendedDigesterOutputStream digesterOutputStream = new ExtendedDigesterOutputStream(digestAlgorithm);){
                signedInfo.generateDigestValues();
                KeyPair dummyKeyPair = AuthnSerializationUtils.getDummyKeyPair();
                signatureAlgorithm.initSign((Key)dummyKeyPair.getPrivate());
                signedInfo.signInOctetStream((OutputStream)((Object)digesterOutputStream));
                String signedSignatureInfoString = new String(digesterOutputStream.getBos().toByteArray());
                byte[] digest = digesterOutputStream.getDigestValue();
                LOG.debug("Digest:" + Hex.encodeHexString((byte[])digest));
                IAuthenticationResult authenticationResult = authenticationProvider.signData(digest);
                byte[] signedDigestValue = authenticationResult.getHashValue();
                signedSignatureInfo = new SignatureInfoSignature(signedSignatureInfoString, signedDigestValue);
            }
        }
        catch (Exception e) {
            throw new AuthenticateException("Error on signing document: " + e);
        }
        return signedSignatureInfo;
    }

    public static void createRenewingRequest(RequestSecurityTokenType rst, String assertion) {
        PropertyInfo tokenTypePi = AuthnSerializationUtils.createPropertyInfo("TokenType", Namespaces.TRUST.getNamespaceUrl(), Namespaces.SAML_2_TOKEN_PROFILE.getNamespaceUrl());
        PropertyInfo requestTypePi = AuthnSerializationUtils.createPropertyInfo("RequestType", Namespaces.TRUST.getNamespaceUrl(), Namespaces.RENEW_TOKEN.getNamespaceUrl());
        PropertyInfo renewTargetPi = AuthnSerializationUtils.createPropertyInfo("RenewTarget", Namespaces.TRUST.getNamespaceUrl(), (Object)new PreMarshalledPrimitive(Namespaces.TRUST.getNamespaceUrl(), "Assertion", assertion));
        rst.any.add(tokenTypePi);
        rst.any.add(requestTypePi);
        rst.any.add(renewTargetPi);
    }

    public static void createLogoutRequest(RequestSecurityTokenType rst, String assertion) {
        PropertyInfo requestTypePi = AuthnSerializationUtils.createPropertyInfo("RequestType", Namespaces.TRUST.getNamespaceUrl(), Namespaces.CANCEL_TOKEN.getNamespaceUrl());
        PropertyInfo cancelTargetPi = AuthnSerializationUtils.createPropertyInfo("CancelTarget", Namespaces.TRUST.getNamespaceUrl(), (Object)new PreMarshalledPrimitive(Namespaces.TRUST.getNamespaceUrl(), "Assertion", assertion));
        rst.any.add(requestTypePi);
        rst.any.add(cancelTargetPi);
    }

    public static String extractAssertion(String responseString) {
        LOG.debug("ResponseString: " + responseString);
        if (responseString.contains(BEGIN_ASSERTION) && responseString.contains(END_ASSERTION)) {
            int beginIndex = responseString.indexOf(BEGIN_ASSERTION);
            int endIndex = responseString.indexOf(END_ASSERTION) + END_ASSERTION.length();
            String assertion = responseString.substring(beginIndex, endIndex);
            LOG.debug("Assertion: " + assertion);
            return assertion;
        }
        return null;
    }

    private static PropertyInfo createPropertyInfo(String name, String nameSpace, Object value) {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.setName(name);
        propertyInfo.setNamespace(nameSpace);
        propertyInfo.setValue(value);
        return propertyInfo;
    }

    private static Document createDocumentFromString(String xml) {
        Document doc;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            Init.init();
            doc = dBuilder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new AuthenticateException("Error on creating w3c.dom document from String: " + e);
        }
        return doc;
    }

    public static String nodeToString(Node bodyNode) {
        StringWriter sw = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(bodyNode), new StreamResult(sw));
        }
        catch (TransformerException e) {
            throw new AuthenticateException("nodeToString Transformer Exception" + e);
        }
        return sw.toString();
    }

    private static KeyPair getDummyKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator kgen = KeyPairGenerator.getInstance("RSA");
        kgen.initialize(2048);
        return kgen.generateKeyPair();
    }

    private static SignatureAlgorithm setupSignatureAlgorithm(XMLSignature sig, SignedInfo signedInfo, String signatureAlgorithm, String uuid) throws TransformationException, XMLSignatureException {
        String signatureAlgorithmNamespace = Namespaces.getSignatureAlgorithmNamespace(signatureAlgorithm);
        signedInfo.getElement().getElementsByTagName("ds:SignatureMethod").item(0).getAttributes().item(0).setNodeValue(signatureAlgorithmNamespace);
        signedInfo.addResourceResolver((ResourceResolverSpi)new ResolverXPointer());
        Transforms transforms = new Transforms(sig.getDocument());
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        HashSet<String> inclusiveNameSpacePrefixes = new HashSet<String>();
        inclusiveNameSpacePrefixes.add("soap");
        InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(sig.getDocument(), inclusiveNameSpacePrefixes);
        signedInfo.getElement().getElementsByTagName("ds:CanonicalizationMethod").item(0).appendChild(inclusiveNamespaces.getElement());
        sig.addDocument("#id-" + uuid, transforms, "http://www.w3.org/2001/04/xmlenc#sha256");
        return signedInfo.getSignatureAlgorithm();
    }

    private static PropertyInfo createSignatureProperty(String signedInfoString, byte[] signedDigestValue, String tokenIdString) {
        SignatureTypeWithSignedInfoString xmlSignature = new SignatureTypeWithSignedInfoString();
        xmlSignature.Id = "SIG-" + UUID.randomUUID().toString();
        xmlSignature.setSignedInfoString(signedInfoString);
        xmlSignature.SignatureValue = new ExtendedSignatureValueType();
        xmlSignature.SignatureValue.value = signedDigestValue;
        xmlSignature.KeyInfo = new KeyInfoType();
        xmlSignature.KeyInfo.Id = UUID.randomUUID().toString();
        SecurityTokenReferenceType securityTokenReference = new SecurityTokenReferenceType();
        ReferenceType_2 reference = new ReferenceType_2();
        reference.URI = "#" + tokenIdString;
        reference.ValueType = Namespaces.X_509_TOKEN_PROFILE.getNamespaceUrl();
        PropertyInfo referenceProperty = AuthnSerializationUtils.createPropertyInfo("Reference", Namespaces.WSSE.getNamespaceUrl(), reference);
        securityTokenReference.any.add(referenceProperty);
        PropertyInfo securityTokenReferenceProperty = AuthnSerializationUtils.createPropertyInfo("SecurityTokenReference", Namespaces.WSSE.getNamespaceUrl(), securityTokenReference);
        xmlSignature.KeyInfo.any.add(securityTokenReferenceProperty);
        return AuthnSerializationUtils.createPropertyInfo("Signature", Namespaces.DS.getNamespaceUrl(), (Object)xmlSignature);
    }

    private static PropertyInfo createBinarySecurityTokenProperty(byte[] certificate, String tokenIdString) {
        byte[] certificateValueEncoded = Base64.getEncoder().encode(certificate);
        BinarySecurityTokenTypeWithId securityToken = new BinarySecurityTokenTypeWithId();
        securityToken.value = new String(certificateValueEncoded);
        securityToken.EncodingType = Namespaces.BASE_64_ENCODING.getNamespaceUrl();
        securityToken.ValueType = Namespaces.X_509_TOKEN_PROFILE.getNamespaceUrl();
        securityToken.setId(tokenIdString);
        PropertyInfo securityTokenPi = AuthnSerializationUtils.createPropertyInfo("BinarySecurityToken", Namespaces.BINARY_SECURITY_TOKEN_PROFILE.getNamespaceUrl(), securityToken.getSimpleValue());
        securityTokenPi.type = BinarySecurityTokenTypeWithId.class;
        return securityTokenPi;
    }
}

