/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication.security;

import de.gematik.ti.epa.fdv.authentication.exceptions.AuthenticateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.utils.DigesterOutputStream;

public class ExtendedDigesterOutputStream
extends DigesterOutputStream {
    ByteArrayOutputStream bos = new ByteArrayOutputStream();

    public ExtendedDigesterOutputStream(MessageDigestAlgorithm algorithm) {
        super(algorithm);
    }

    public void write(int messageLength) {
        this.bos.write(messageLength);
        super.write(messageLength);
    }

    public void write(byte[] message, int from, int to) {
        try {
            byte[] bytes = Arrays.copyOfRange(message, from, from + to);
            this.bos.write(bytes);
            super.write(message, from, to);
        }
        catch (IOException e) {
            throw new AuthenticateException("Error on writing DigesterOutputStream" + e);
        }
    }

    public ByteArrayOutputStream getBos() {
        return this.bos;
    }
}

