/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication.security;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateUtil.class);

    private CertificateUtil() {
    }

    public static X509Certificate getCertificate(byte[] certBytes) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
            Certificate certificate = cf.generateCertificate(bis);
            return (X509Certificate)certificate;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not load certificate: " + e.getLocalizedMessage(), e);
        }
    }

    public static String getSurnameGivenName(X509Certificate certificate) {
        String names = certificate.getSubjectDN().getName();
        LOG.debug("names:" + names);
        String[] spliter = names.split("[,+]");
        String givenName = "";
        for (String spl : spliter) {
            String temp = spl.trim();
            if (!temp.toUpperCase().startsWith("GIVENNAME=")) continue;
            givenName = temp.substring("GIVENNAME=".length());
            LOG.debug("gn:" + givenName);
        }
        String surName = "";
        for (String spl : spliter) {
            String temp = spl.trim();
            if (!(temp = temp.trim()).toUpperCase().startsWith("SURNAME=")) continue;
            surName = temp.substring("SURNAME=".length());
            LOG.debug("surName:" + surName);
        }
        return "(" + surName + ", " + givenName + ")";
    }

    private static String getFirstFieldFormCertificate(String fieldName, X509Certificate certX509) {
        String[] fields = CertificateUtil.getFieldsFormCertificate(fieldName, certX509);
        if (fields.length > 0) {
            return fields[0];
        }
        return "";
    }

    private static String[] getFieldsFormCertificate(String fieldName, X509Certificate certX509) {
        String x500Principal = certX509.getIssuerX500Principal().getName();
        StringBuilder fields = new StringBuilder();
        StringTokenizer st = new StringTokenizer(x500Principal, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int idx = token.indexOf(61);
            if (idx < 0 || !fieldName.equals(token.substring(0, idx))) continue;
            if (fields.length() > 0) {
                fields.append(",");
            }
            fields.append(token.substring(idx + 1));
        }
        return fields.toString().split(",");
    }

    public static String getCommonName(X509Certificate certificate) {
        return CertificateUtil.getFirstFieldFormCertificate("CN", certificate);
    }
}

