/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication;

import de.gematik.ti.epa.fdv.authentication.event.AuthnProviderSelectionProvider;
import de.gematik.ti.epa.fdv.authentication.event.RequestSelectAuthenticatorEvent;
import de.gematik.ti.epa.fdv.authentication.exceptions.AuthenticateException;
import de.gematik.ti.epa.fdv.authentication.service.provider.api.IAuthenticator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.greenrobot.eventbus.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnService {
    private static final long TIMEOUT = 30L;
    private static final Logger LOG = LoggerFactory.getLogger(AuthnService.class);
    private IAuthenticator selectedAuthnProvider = null;
    private final List<IAuthenticator> listAuthn = new ArrayList<IAuthenticator>();

    public AuthnService() {
        Iterator<IAuthenticator> iterator = ServiceLoader.load(IAuthenticator.class).iterator();
        iterator.forEachRemaining(this.listAuthn::add);
    }

    public List<IAuthenticator> getAvailableAuthenticationProvider() {
        return this.listAuthn;
    }

    public IAuthenticator getAuthenticationProvider() {
        if (this.selectedAuthnProvider != null) {
            LOG.debug("Found selectedAuthnProvider: " + this.selectedAuthnProvider);
            return this.selectedAuthnProvider;
        }
        LOG.debug("Found listAuthn: " + this.listAuthn + " and selectedAuthnProvider: " + this.selectedAuthnProvider);
        if (this.selectedAuthnProvider == null && this.listAuthn.size() > 1) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            AuthnProviderSelectionProvider authnProviderSelectionProvider = new AuthnProviderSelectionProvider();
            EventBus.getDefault().post((Object)new RequestSelectAuthenticatorEvent(authnProviderSelectionProvider, this.listAuthn));
            Future<IAuthenticator> future = executor.submit(authnProviderSelectionProvider);
            executor.shutdown();
            try {
                this.selectedAuthnProvider = future.get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                future.cancel(true);
                throw new AuthenticateException(e);
            }
        }
        if (this.selectedAuthnProvider == null && this.listAuthn.size() == 1) {
            this.selectedAuthnProvider = this.listAuthn.get(0);
            return this.selectedAuthnProvider;
        }
        throw new AuthenticateException("No authenticator available.");
    }
}

