/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication;

import de.gematik.ti.epa.fdv.authentication.AuthenticationBindingSoap;
import de.gematik.ti.epa.fdv.authentication.AuthnService;
import de.gematik.ti.epa.fdv.authentication.exceptions.AuthenticateException;
import de.gematik.ti.epa.fdv.authentication.security.CertificateUtil;
import de.gematik.ti.epa.fdv.authentication.serialization.AuthnSerializationUtils;
import de.gematik.ti.epa.fdv.authentication.service.provider.api.IAuthenticator;
import de.gematik.ti.epa.fdv.authentication.soap.SignatureInfoSignature;
import de.gematik.ti.epa.fdv.gen.authentication.RequestSecurityTokenResponseType;
import de.gematik.ti.epa.fdv.gen.authentication.RequestSecurityTokenType;
import de.gematik.ti.epa.fdv.gen.authentication.SignChallengeType;
import de.gematik.ti.healthcardaccess.operation.ResultOperation;
import de.gematik.ti.healthcardaccess.operation.Subscriber;
import java.net.URL;
import java.security.cert.X509Certificate;
import org.ksoap2.serialization.PropertyInfo;
import org.w3c.dom.Document;

public final class Authn {
    private static Authn instance;
    private Subscriber<IAuthenticator> authnProviderSubscriber;
    private final URL url;
    private AuthenticationBindingSoap service;
    private IAuthenticator authenticationProvider;

    private Authn(URL url) {
        this.url = url;
        this.initAuthService();
        this.initProviderSubscriber();
        ResultOperation<IAuthenticator> authenticatorResult = this.getAuthnProvider();
        if (authenticatorResult != null) {
            authenticatorResult.subscribe(this.authnProviderSubscriber);
        }
    }

    public static Authn getInstance(URL url) {
        if (instance == null) {
            instance = new Authn(url);
            return instance;
        }
        return instance;
    }

    public ResultOperation<String> loginCreateChallenge() {
        RequestSecurityTokenResponseType createChallengeResponse;
        this.service.setIsLoginTokenRequest(false);
        try {
            createChallengeResponse = this.service.LoginCreateChallenge(new RequestSecurityTokenType());
        }
        catch (Exception e) {
            throw new AuthenticateException("LoginCreateChallenge failed: " + e);
        }
        String challenge = ((SignChallengeType)((PropertyInfo)createChallengeResponse.any.get((int)0)).getValue()).Challenge;
        return ResultOperation.unitRo((Object)challenge);
    }

    public ResultOperation<String> loginCreateToken(String challenge) {
        RequestSecurityTokenResponseType rstr = AuthnSerializationUtils.createRstrForLoginCreateToken(challenge);
        byte[] certificate = this.authenticationProvider.getCertificateValue();
        X509Certificate x509Cert = CertificateUtil.getCertificate(certificate);
        String signatureAlgorithm = x509Cert.getPublicKey().getAlgorithm();
        Document docToSign = AuthnSerializationUtils.createDocFromRstr(rstr, this.service);
        String uuid = this.service.getUuid().toString();
        SignatureInfoSignature sig = AuthnSerializationUtils.signDocument(docToSign, this.authenticationProvider, signatureAlgorithm, uuid);
        try {
            this.service.setSecurityHeader(AuthnSerializationUtils.createSecurityHeader(sig, certificate));
            this.service.setShouldSendRequest(true);
            this.service.setIsLoginTokenRequest(true);
            this.service.setRenewTokenRequest(false);
            this.service.LoginCreateToken(rstr);
        }
        catch (Exception e) {
            throw new AuthenticateException("LoginCreateToken failed: " + e);
        }
        String assertion = this.service.getAssertion();
        return ResultOperation.unitRo((Object)assertion);
    }

    public ResultOperation<String> renewToken(String assertion) {
        RequestSecurityTokenType rst = new RequestSecurityTokenType();
        this.service.setShouldSendRequest(true);
        this.service.setIsLoginTokenRequest(false);
        this.service.setRenewTokenRequest(true);
        if (assertion != null) {
            AuthnSerializationUtils.createRenewingRequest(rst, assertion);
            try {
                this.service.RenewToken(rst);
            }
            catch (Exception e) {
                throw new AuthenticateException("RenewToken failed: " + e);
            }
        }
        String newAssertion = this.service.getAssertion();
        return ResultOperation.unitRo((Object)newAssertion);
    }

    public ResultOperation<RequestSecurityTokenResponseType> logoutToken(String assertion) {
        RequestSecurityTokenType rst = new RequestSecurityTokenType();
        RequestSecurityTokenResponseType rstr = null;
        this.service.setShouldSendRequest(true);
        this.service.setIsLoginTokenRequest(false);
        this.service.setRenewTokenRequest(false);
        if (assertion != null) {
            AuthnSerializationUtils.createLogoutRequest(rst, assertion);
            try {
                rstr = this.service.LogoutToken(rst);
            }
            catch (Exception e) {
                throw new AuthenticateException("LogoutToken failed" + e);
            }
        }
        return ResultOperation.unitRo(rstr);
    }

    private void initProviderSubscriber() {
        this.authnProviderSubscriber = new Subscriber<IAuthenticator>(){

            public void onSuccess(IAuthenticator value) {
                Authn.this.authenticationProvider = value;
            }

            public void onError(Throwable t) throws AuthenticateException {
                throw new AuthenticateException("Failed to load authentication provider: " + t);
            }
        };
    }

    private void initAuthService() {
        this.service = new AuthenticationBindingSoap(this.url.toString());
        this.service.enableLogging = false;
        this.service.createClassesForAny = true;
    }

    private ResultOperation<IAuthenticator> getAuthnProvider() {
        AuthnService authServiceLoader = new AuthnService();
        this.authenticationProvider = authServiceLoader.getAuthenticationProvider();
        if (this.authenticationProvider != null) {
            return ResultOperation.unitRo((Object)this.authenticationProvider);
        }
        return null;
    }
}

