/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.authentication;

import com.easywsdl.exksoap2.ws_specifications.profile.WS_Profile;
import de.gematik.ti.epa.fdv.authentication.exceptions.AuthenticateException;
import de.gematik.ti.epa.fdv.authentication.security.Namespaces;
import de.gematik.ti.epa.fdv.authentication.serialization.AuthnSerializationUtils;
import de.gematik.ti.epa.fdv.authentication.serialization.HeaderConverter;
import de.gematik.ti.epa.fdv.authentication.soap.ExpandedSoapSerializationEnvelope;
import de.gematik.ti.epa.fdv.authentication.transport.AdvancedHttpTransportSe;
import de.gematik.ti.epa.fdv.authentication.transport.AdvancedHttpsTransportSe;
import de.gematik.ti.epa.fdv.authentication.transport.SoapDataDelegate;
import de.gematik.ti.epa.fdv.gen.authentication.ExtendedSoapSerializationEnvelope;
import de.gematik.ti.epa.fdv.gen.authentication.I_Authentication_Insurant_Binding_Soap12;
import de.gematik.ti.epa.fdv.gen.authentication.SecurityHeaderType;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import org.ksoap2.transport.Transport;
import org.kxml2.kdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationBindingSoap
extends I_Authentication_Insurant_Binding_Soap12 {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationBindingSoap.class);
    private static final int CONTINUATION = 60000;
    private static final int PORT = 443;
    private SecurityHeaderType securityHeader = null;
    private boolean shouldSendRequest = true;
    private boolean isLoginTokenRequest = false;
    private boolean isRenewTokenRequest = false;
    private final UUID uuid;
    private final String address;
    private final URI uri;
    private String assertion;
    private final SoapDataDelegate delegate;
    private byte[] requestData;

    public AuthenticationBindingSoap(String url) {
        super(url);
        this.address = url;
        this.uuid = UUID.randomUUID();
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new AuthenticateException(e);
        }
        this.delegate = new SoapDataDelegate();
    }

    public List sendRequest(String methodName, ExtendedSoapSerializationEnvelope envelope, Transport transport, WS_Profile profile) {
        SoapDataDelegate soapTransport = new SoapDataDelegate();
        List response = null;
        if (!this.shouldSendRequest) {
            try {
                this.requestData = soapTransport.generateRequestData(envelope);
            }
            catch (IOException e) {
                throw new AuthenticateException(e);
            }
        }
        try {
            response = super.sendRequest(methodName, envelope, transport, profile);
        }
        catch (Exception e) {
            throw new AuthenticateException(e);
        }
        finally {
            String responseString = this.delegate.getResponseString();
            LOG.debug("Response: " + responseString);
            if (this.isLoginTokenRequest || this.isRenewTokenRequest) {
                this.assertion = null;
                this.assertion = AuthnSerializationUtils.extractAssertion(responseString);
                LOG.debug("Request: " + transport.requestDump);
            }
        }
        return response;
    }

    public ExtendedSoapSerializationEnvelope createEnvelope() {
        ExpandedSoapSerializationEnvelope envelope = new ExpandedSoapSerializationEnvelope(120);
        envelope.createClassesForAny = this.createClassesForAny;
        envelope.implicitTypes = true;
        envelope.setUuid(this.uuid);
        if (this.securityHeader != null && this.isLoginTokenRequest) {
            Element headerElement = HeaderConverter.convertToHeader(this.securityHeader, Namespaces.WSSE.getNamespaceUrl(), "Security");
            envelope.headerOut = new Element[1];
            envelope.headerOut[0] = headerElement;
        }
        return envelope;
    }

    protected Transport createTransport() {
        if ("https".equalsIgnoreCase(this.uri.getScheme())) {
            int port = this.uri.getPort() > 0 ? this.uri.getPort() : 443;
            AdvancedHttpsTransportSe transport = new AdvancedHttpsTransportSe(this.delegate, this.uri.getHost(), port, this.uri.getPath(), 60000);
            return transport;
        }
        AdvancedHttpTransportSe transport = new AdvancedHttpTransportSe(this.delegate, this.address, 60000);
        return transport;
    }

    void setSecurityHeader(SecurityHeaderType securityHeader) {
        this.securityHeader = securityHeader;
    }

    public void setShouldSendRequest(boolean shouldSendRequest) {
        this.shouldSendRequest = shouldSendRequest;
    }

    void setIsLoginTokenRequest(boolean loginTokenRequest) {
        this.isLoginTokenRequest = loginTokenRequest;
    }

    void setRenewTokenRequest(boolean renewTokenRequest) {
        this.isRenewTokenRequest = renewTokenRequest;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    String getAssertion() {
        return this.assertion;
    }

    public byte[] getRequestData() {
        return this.requestData;
    }
}

