/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.fdv.gen.authentication;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.kobjects.base64.Base64;
import org.ksoap2.serialization.AttributeContainer;
import org.ksoap2.serialization.AttributeInfo;
import org.ksoap2.serialization.KvmSerializable;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapPrimitive;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.kxml2.kdom.Element;

public class Helper {
    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Object getAttribute(AttributeContainer obj, String name, String namespace) {
        for (int i = 0; i < obj.getAttributeCount(); ++i) {
            AttributeInfo info = new AttributeInfo();
            obj.getAttributeInfo(i, info);
            if (!info.name.equals(name) || !info.namespace.equals(namespace)) continue;
            return info.getValue();
        }
        return null;
    }

    public static byte[] getBinary(Object obj, boolean isSwaRef) {
        if (obj != null && obj.getClass().equals(SoapPrimitive.class)) {
            SoapPrimitive j = (SoapPrimitive)obj;
            if (j.toString() != null) {
                return Base64.decode((String)j.toString());
            }
        } else if (obj != null && obj.getClass().equals(String.class)) {
            String j = (String)obj;
            if (j.toString() != null) {
                return Base64.decode((String)j.toString());
            }
        } else {
            SoapObject j;
            if (obj != null && obj instanceof byte[]) {
                return (byte[])obj;
            }
            if (obj != null && obj.getClass().equals(SoapObject.class) && (j = (SoapObject)obj).getPropertyCount() > 0) {
                return Helper.getBinary(j.getProperty(0), isSwaRef);
            }
        }
        return null;
    }

    public static Element convertToHeader(Object obj, String namespace, String name) {
        Object value;
        PropertyInfo info;
        int i;
        Element parentElement = new Element().createElement(namespace, name);
        if (obj == null) {
            return parentElement;
        }
        if (obj instanceof KvmSerializable) {
            KvmSerializable soapObject = (KvmSerializable)obj;
            for (i = 0; i < soapObject.getPropertyCount(); ++i) {
                info = new PropertyInfo();
                soapObject.getPropertyInfo(i, new Hashtable(), info);
                value = soapObject.getProperty(i);
                if (value == null || value == SoapPrimitive.NullSkip || value == SoapPrimitive.NullNilElement) continue;
                info.setValue(value);
                Element el1 = Helper.convertToHeader(info.getValue(), info.getNamespace(), info.getName());
                parentElement.addChild(2, (Object)el1);
            }
        } else if (obj != null && obj != SoapPrimitive.NullSkip && obj != SoapPrimitive.NullNilElement) {
            String value2 = obj.toString();
            if (obj instanceof Date) {
                Date date = (Date)obj;
                value2 = Helper.getDateFormat().format(date);
            }
            parentElement.addChild(4, (Object)value2);
        }
        if (obj instanceof AttributeContainer) {
            AttributeContainer attrContainer = (AttributeContainer)obj;
            for (i = 0; i < attrContainer.getAttributeCount(); ++i) {
                info = new AttributeInfo();
                attrContainer.getAttributeInfo(i, (AttributeInfo)info);
                value = info.getValue();
                parentElement.setAttribute(info.namespace, info.name, value != null ? value.toString() : "");
            }
        }
        return parentElement;
    }

    public static Element findOutHeader(String name, SoapSerializationEnvelope envelope) {
        if (envelope.headerIn == null) {
            return null;
        }
        for (int i = 0; i < envelope.headerIn.length; ++i) {
            Element elem = envelope.headerIn[i];
            if (!elem.getName().equals(name) || elem.getChildCount() <= 0 && elem.getAttributeCount() <= 0) continue;
            return elem;
        }
        return null;
    }

    public static Object convertToSoapObject(Element element) {
        if (element.getChildCount() == 0 || element.getChildCount() == 1 && !(element.getChild(0) instanceof Element)) {
            SoapPrimitive primitive = new SoapPrimitive(element.getNamespace(), element.getName(), element.getChildCount() == 1 ? element.getText(0) : null);
            return primitive;
        }
        SoapObject obj = new SoapObject(element.getNamespace(), element.getName());
        for (int i = 0; i < element.getChildCount(); ++i) {
            Element childElement = element.getElement(i);
            Object childObject = Helper.convertToSoapObject(childElement);
            if (childObject instanceof SoapObject) {
                SoapObject soapObj = (SoapObject)childObject;
                obj.addProperty(soapObj.getName(), childObject);
                continue;
            }
            SoapPrimitive primitive = (SoapPrimitive)childObject;
            obj.addProperty(primitive.getName(), (Object)primitive);
        }
        return obj;
    }

    public static Date ConvertFromWebService(String strDate) {
        String[] formats;
        for (String frm : formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd"}) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(frm, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.parse(strDate);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static SimpleDateFormat getDateTimeFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public static SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static ArrayList<PropertyInfo> getProperties(SoapObject soapObject, String name) {
        ArrayList<PropertyInfo> list = new ArrayList<PropertyInfo>();
        int size = soapObject.getPropertyCount();
        for (int i0 = 0; i0 < size; ++i0) {
            PropertyInfo info = soapObject.getPropertyInfo(i0);
            if (!info.name.equals(name)) continue;
            list.add(info);
        }
        return list;
    }

    public static UUID emptyGuid() {
        return new UUID(0L, 0L);
    }
}

