package de.gematik.ti.epa.vzd.gem.command.commandExecutions;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThrows;

import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.gem.command.CommandsBuilder;
import de.gematik.ti.epa.vzd.gem.command.ExecutionCollection;
import de.gematik.ti.epa.vzd.gem.invoker.ConfigHandler;
import de.gematik.ti.epa.vzd.gem.invoker.ConnectionPool;
import generated.CommandType;
import java.io.File;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ExecutionBaseIntegrationTest {

    private static final String[] TEST_ARGS = new String[]{"-p",
        "src" + File.separator + "test" + File.separator + "resources" + File.separator
            + "config" + File.separator + "IntegrationConfig.txt", "-c",
        "src" + File.separator + "test" + File.separator + "resources" + File.separator
            + "config" + File.separator + "Credentials.txt", "-b", "src" + File.separator + "test" + File.separator + "resources" + File.separator
        + "config" + File.separator + "commands" + File.separator + "executionBase.xml"};
    public static List<CommandType> commands;

    @Before
    public void initConfigHandler() {
        ConfigHandler.setConfigHandler(null);
        ConfigHandler.init(TEST_ARGS);
        ExecutionCollection.init(ConnectionPool.createConnectionPool(1));
        commands = new CommandsBuilder().buildCommands();
    }

    @After
    public void unsetConfigHandler() {
        ConfigHandler.setConfigHandler(null);
        ExecutionCollection.getInstance().setExecutionCollection(null);
    }

    @Test
    public void getUidTestMissMatchUid() throws InterruptedException, ApiException {
        ReadDirEntryExecution readDirEntryExecution = new ReadDirEntryExecution(ConnectionPool.createConnectionPool(1));
        ReadDirEntryCertExecution readDirEntryCertExecution = new ReadDirEntryCertExecution(ConnectionPool.createConnectionPool(1));

        readDirEntryCertExecution.executeCommand(commands.get(0),readDirEntryCertExecution.connectionPool.getConnection());

        ApiException exception = assertThrows(ApiException.class,
            () -> readDirEntryExecution.executeCommand(commands.get(0), readDirEntryExecution.connectionPool.getConnection()));
        assertEquals("UID delivered by TelematikId does not match the UID in command file", exception.getMessage());
    }

}
