/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.api.CertificateAdministrationApi;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.model.CreateDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.UserCertificate;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.api.GemCertificateAdministrationApi;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ModifyDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import generated.DistinguishedNameType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDirEntryCertExecution
extends ExecutionBase {
    private Logger LOG = LoggerFactory.getLogger(ModifyDirEntryExecution.class);
    private CertificateAdministrationApi certificateAdministrationApi = new GemCertificateAdministrationApi(this.apiClient);

    public ModifyDirEntryCertExecution(GemApiClient api) {
        super(api, CommandNamesEnum.MOD_DIR_CERT);
    }

    @Override
    public boolean checkValidation(CommandType command) {
        DistinguishedNameType dn;
        return command.getUserCertificate() == null || command.getUserCertificate().getDn() == null || !StringUtils.isBlank((dn = command.getUserCertificate().getDn()).getUid()) && !StringUtils.isBlank(dn.getCn());
    }

    @Override
    public boolean executeCommands() {
        this.LOG.info("The execution for ModifyCertificate is exposed");
        return true;
    }

    protected ApiResponse<UserCertificate> executeCommand(CommandType command) {
        this.apiClient.validateToken();
        CreateDirectoryEntry createDirectoryEntry = Transformer.getCreateDirectoryEntry(command);
        ApiResponse<UserCertificate> response = null;
        for (UserCertificate userCertificate : createDirectoryEntry.getUserCertificates()) {
            try {
                response = this.certificateAdministrationApi.modifyDirectoryEntryCertificateWithHttpInfo(userCertificate.getDn().getUid(), userCertificate.getDn().getCn(), userCertificate);
            }
            catch (ApiException e) {
                e.printStackTrace();
            }
            if (response.getStatusCode() == 200) {
                this.LOG.debug("Modify directory entry execution successful operated\n" + response.getData());
                continue;
            }
            throw new CommandException("Modify directory entry execution failed. Response-Status was: " + response.getStatusCode() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
        }
        return response;
    }

    @Override
    public boolean postCheck() {
        try {
            super.postCheck();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

