/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.model.DirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.UserCertificate;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionCollection;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import de.gematik.ti.epa.vzd.gemClient.exceptions.GemClientException;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import generated.DistinguishedNameType;
import generated.UserCertificateType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionBase {
    private Logger LOG = LoggerFactory.getLogger(ExecutionBase.class);
    protected GemApiClient apiClient;
    protected CommandNamesEnum execCommand;
    protected List<CommandType> commands;

    public ExecutionBase(GemApiClient api, CommandNamesEnum cmd) {
        this.apiClient = api;
        this.execCommand = cmd;
        this.commands = new ArrayList<CommandType>();
    }

    public boolean canHandleCommand(CommandNamesEnum cmd) {
        return this.execCommand.equals((Object)cmd);
    }

    public boolean preCheck(CommandType command) {
        try {
            if (!this.checkValidation(command)) {
                throw new CommandException("Command invalid. Please check " + command.getName() + " " + command.getUserCertificate());
            }
            this.commands.add(command);
            return true;
        }
        catch (Exception ex) {
            this.LOG.error(ex.getMessage());
            return false;
        }
    }

    public abstract boolean checkValidation(CommandType var1);

    public abstract boolean executeCommands();

    public boolean postCheck() {
        try {
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected boolean isEntryPresent(CommandType command) {
        if (command.getDn() != null) {
            CommandType searchCommand = new CommandType();
            DistinguishedNameType dn = new DistinguishedNameType();
            dn.setUid(command.getDn().getUid());
            searchCommand.setDn(dn);
            try {
                ApiResponse<List<DirectoryEntry>> response = ExecutionCollection.getInstance().getReadDirEntryExecution().executeCommand(searchCommand);
                return response.getStatusCode() == 200;
            }
            catch (ApiException ex) {
                if (ex.getCode() == 0) {
                    throw new GemClientException("The server you address is probably not reachable at the moment");
                }
                return false;
            }
        }
        return this.serachByTelematikId(command);
    }

    private boolean serachByTelematikId(CommandType command) {
        UserCertificateType userCertificate = command.getUserCertificate();
        if (userCertificate != null) {
            try {
                CommandType searchCommand = new CommandType();
                searchCommand.setUserCertificate(new UserCertificateType());
                searchCommand.getUserCertificate().setTelematikID(userCertificate.getTelematikID());
                ApiResponse<List<UserCertificate>> response = ExecutionCollection.getInstance().getReadDirEntryCertExecution().executeCommand(searchCommand);
                return response.getStatusCode() == 200;
            }
            catch (ApiException ex) {
                this.LOG.error(ex.getMessage());
                return false;
            }
        }
        throw new GemClientException("No valid parameter found for present check" + Transformer.getBaseDirectoryEntryFromCommandType(command));
    }
}

