/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.api.DirectoryEntryAdministrationApi;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.api.GemDirectoryEntryAdministrationApi;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDirEntryExecution
extends ExecutionBase {
    private Logger LOG = LoggerFactory.getLogger(DeleteDirEntryExecution.class);
    private final DirectoryEntryAdministrationApi directoryEntryAdministrationApi = new GemDirectoryEntryAdministrationApi(this.apiClient);

    public DeleteDirEntryExecution(GemApiClient api) {
        super(api, CommandNamesEnum.DEL_DIR_ENTRY);
    }

    @Override
    public boolean checkValidation(CommandType command) {
        boolean check = true;
        if (command.getDn() != null) {
            if (command.getDn().getUid() == null || command.getDn().getUid().equals("")) {
                this.LOG.error("Missing argument -> uid for command " + command.getName() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
                check = false;
            }
        } else {
            this.LOG.error("Missing element \"dn\" " + command.getName() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
            check = false;
        }
        return check;
    }

    @Override
    public boolean executeCommands() {
        boolean runSuccessful = true;
        if (this.commands.size() == 0) {
            return true;
        }
        for (CommandType command : this.commands) {
            if (this.isEntryPresent(command)) {
                try {
                    this.executeCommand(command);
                }
                catch (Exception ex) {
                    this.LOG.error("An error have occured: " + ex.getMessage());
                    runSuccessful = false;
                }
                continue;
            }
            this.LOG.debug(command.getDn().getUid() + " could not be found");
            runSuccessful = false;
        }
        return runSuccessful;
    }

    private void executeCommand(CommandType command) throws ApiException {
        this.apiClient.validateToken();
        ApiResponse<Void> response = this.directoryEntryAdministrationApi.deleteDirectoryEntryWithHttpInfo(command.getDn().getUid());
        if (response.getStatusCode() != 200) {
            if (response.getStatusCode() == 404) {
                this.LOG.debug(command.getDn().getUid() + " could not be found");
                throw new CommandException(command.getDn().getUid() + " could not be found");
            }
            throw new CommandException("Delete directory entry execution failed. Response-Status was: " + response.getStatusCode() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
        }
        this.LOG.debug("Delete directory entry execution successful operated for " + command.getDn().getUid());
    }

    @Override
    public boolean postCheck() {
        try {
            super.postCheck();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

