/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.api.DirectoryEntryAdministrationApi;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.model.CreateDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.api.GemDirectoryEntryAdministrationApi;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionCollection;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import generated.UserCertificateType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDirEntryExecution
extends ExecutionBase {
    private final DirectoryEntryAdministrationApi directoryEntryAdministrationApi;
    private Logger LOG = LoggerFactory.getLogger(AddDirEntryExecution.class);

    public AddDirEntryExecution(GemApiClient api) {
        super(api, CommandNamesEnum.ADD_DIR_ENTRY);
        this.directoryEntryAdministrationApi = new GemDirectoryEntryAdministrationApi(this.apiClient);
    }

    @Override
    public boolean checkValidation(CommandType command) {
        boolean check = true;
        UserCertificateType userCertificateType = command.getUserCertificate();
        if (userCertificateType == null) {
            this.LOG.error("Missing element \"UserCertificate\" " + command.getName() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
            check = false;
        } else {
            String telematikId = userCertificateType.getTelematikID();
            String userCertificate = userCertificateType.getUserCertificate();
            if (StringUtils.isBlank(telematikId) && StringUtils.isBlank(userCertificate)) {
                check = false;
            }
            if (!check) {
                this.LOG.error("Missing argument -> telematikId or userCertificate for command " + command.getName() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
            }
        }
        return check;
    }

    @Override
    public boolean executeCommands() {
        boolean runSuccessful = true;
        if (this.commands.size() == 0) {
            return true;
        }
        for (CommandType command : this.commands) {
            if (!this.isEntryPresent(command)) {
                try {
                    this.executeCommand(command);
                }
                catch (Exception ex) {
                    this.LOG.error("An error have occured: " + ex.getMessage() + "\n" + Transformer.getCreateDirectoryEntry(command));
                    runSuccessful = false;
                }
                continue;
            }
            runSuccessful = this.doModify(command);
        }
        return runSuccessful;
    }

    protected ApiResponse<DistinguishedName> executeCommand(CommandType command) throws ApiException {
        this.apiClient.validateToken();
        CreateDirectoryEntry createDirectoryEntry = Transformer.getCreateDirectoryEntry(command);
        ApiResponse<DistinguishedName> response = this.directoryEntryAdministrationApi.addDirectoryEntryWithHttpInfo(createDirectoryEntry);
        if (response.getStatusCode() != 201) {
            throw new CommandException("Add directory entry execution failed. Response-Status was: " + response.getStatusCode() + "\n" + Transformer.getCreateDirectoryEntry(command));
        }
        this.LOG.debug("Add directory entry execution successful operated\n" + response.getData());
        return response;
    }

    private boolean doModify(CommandType command) {
        this.LOG.debug("Entry is already present in VZD. Will Proceed with modify directory entry command");
        try {
            ExecutionCollection.getInstance().getModifyDirEntry().executeCommand(command);
            return true;
        }
        catch (Exception ex) {
            this.LOG.error("Modify directory entry execution failed. " + ex.getMessage() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
            return false;
        }
    }

    @Override
    public boolean postCheck() {
        try {
            super.postCheck();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

