/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.api.CertificateAdministrationApi;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.model.BaseDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.CreateDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import de.gematik.ti.epa.vzd.client.model.UserCertificate;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.api.GemCertificateAdministrationApi;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.AddDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionCollection;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import generated.DistinguishedNameType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDirEntryCertExecution
extends ExecutionBase {
    private CertificateAdministrationApi certificateAdministrationApi;
    private Logger LOG = LoggerFactory.getLogger(AddDirEntryExecution.class);

    public AddDirEntryCertExecution(GemApiClient api) {
        super(api, CommandNamesEnum.ADD_DIR_CERT);
        this.certificateAdministrationApi = new GemCertificateAdministrationApi(this.apiClient);
    }

    @Override
    public boolean checkValidation(CommandType command) {
        DistinguishedNameType certDn;
        if (command.getUserCertificate() == null) {
            return false;
        }
        if (StringUtils.isBlank(command.getUserCertificate().getUserCertificate())) {
            return false;
        }
        String uid = null;
        if (command.getDn() != null) {
            uid = command.getDn().getUid();
        }
        if (StringUtils.isBlank(uid) && (certDn = command.getUserCertificate().getDn()) != null) {
            uid = certDn.getUid();
        }
        return !StringUtils.isBlank(uid);
    }

    @Override
    public boolean executeCommands() {
        boolean runSuccessful = true;
        if (this.commands.size() == 0) {
            return true;
        }
        for (CommandType command : this.commands) {
            if (this.isEntryPresent(command)) {
                try {
                    this.executeCommand(command);
                }
                catch (Exception ex) {
                    this.LOG.error("An error have occured: " + ex.getMessage());
                    runSuccessful = false;
                }
                continue;
            }
            runSuccessful = this.doModify(command);
        }
        return runSuccessful;
    }

    private ApiResponse<DistinguishedName> executeCommand(CommandType command) {
        this.apiClient.validateToken();
        boolean runSucsessfull = true;
        CreateDirectoryEntry createDirectoryEntry = Transformer.getCreateDirectoryEntry(command);
        ApiResponse<DistinguishedName> response = null;
        for (UserCertificate userCertificate : createDirectoryEntry.getUserCertificates()) {
            try {
                String uid = this.getUid(createDirectoryEntry.getDirectoryEntryBase(), userCertificate);
                response = this.addSingleCertificate(uid, userCertificate);
                if (response.getStatusCode() != 201) continue;
                this.LOG.debug("Certificate successful added: \n" + userCertificate);
            }
            catch (ApiException e) {
                runSucsessfull = false;
                this.LOG.error("Something went wrong will adding certificate. Responsecode: " + e.getCode() + " certificate: " + userCertificate.getUserCertificate());
            }
        }
        if (!runSucsessfull) {
            throw new CommandException("At least one certificate could not be added in:\n" + Transformer.getCreateDirectoryEntry(command));
        }
        return response;
    }

    private String getUid(BaseDirectoryEntry directoryEntryBase, UserCertificate userCertificate) {
        DistinguishedName dn;
        String uidCert = null;
        String uidEntry = null;
        if (userCertificate.getDn() != null) {
            uidCert = userCertificate.getDn().getUid();
        }
        if (directoryEntryBase != null && (dn = directoryEntryBase.getDn()) != null) {
            uidEntry = dn.getUid();
        }
        return uidCert == null ? uidEntry : uidCert;
    }

    private ApiResponse<DistinguishedName> addSingleCertificate(String uid, UserCertificate userCertificate) throws ApiException {
        return this.certificateAdministrationApi.addDirectoryEntryCertificateWithHttpInfo(uid, userCertificate);
    }

    private boolean doModify(CommandType command) {
        this.LOG.debug("Certificate is already present in VZD. Will Proceed with modify certificate entry command");
        try {
            ExecutionCollection.getInstance().getModifyDirEntryCertExecution().executeCommand(command);
            return true;
        }
        catch (Exception ex) {
            this.LOG.error("Modify certificate entry execution failed. " + ex.getMessage() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
            return false;
        }
    }

    @Override
    public boolean postCheck() {
        try {
            super.postCheck();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

