/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command;

import de.gematik.ti.epa.vzd.client.model.BaseDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.CreateDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import de.gematik.ti.epa.vzd.client.model.UserCertificate;
import generated.CommandType;
import generated.DistinguishedNameType;
import generated.UserCertificateType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Transformer {
    public static BaseDirectoryEntry getBaseDirectoryEntryFromCommandType(CommandType command) {
        BaseDirectoryEntry baseDirectoryEntry = new BaseDirectoryEntry();
        if (command.getDn() != null) {
            baseDirectoryEntry.setDn(Transformer.getDnFromDnType(command.getDn()));
        }
        baseDirectoryEntry.setDisplayName(command.getDisplayName());
        baseDirectoryEntry.setStreetAddress(command.getStreetAddress());
        baseDirectoryEntry.setPostalCode(command.getPostalCode());
        baseDirectoryEntry.setLocalityName(command.getLocalityName());
        baseDirectoryEntry.setStateOrProvinceName(command.getStateOrProvinceName());
        baseDirectoryEntry.setCn(command.getCn());
        baseDirectoryEntry.setTitle(command.getTitle());
        baseDirectoryEntry.setOrganization(command.getOrganization());
        baseDirectoryEntry.setOtherName(command.getOtherName());
        if (command.getSpecialization().size() != 0) {
            baseDirectoryEntry.setSpecialization(command.getSpecialization());
        }
        if (command.getDomainID().size() != 0) {
            baseDirectoryEntry.setDomainID(command.getDomainID());
        }
        return baseDirectoryEntry;
    }

    private static DistinguishedName getDnFromDnType(DistinguishedNameType dn) {
        DistinguishedName distinguishedName = new DistinguishedName();
        distinguishedName.setUid(dn.getUid());
        distinguishedName.setCn(dn.getCn());
        if (dn.getDc().size() != 0) {
            distinguishedName.setDc(dn.getDc());
        }
        if (dn.getOu().size() != 0) {
            distinguishedName.setOu(dn.getOu());
        }
        return distinguishedName;
    }

    public static CreateDirectoryEntry getCreateDirectoryEntry(CommandType command) {
        CreateDirectoryEntry createDirectoryEntry = new CreateDirectoryEntry();
        createDirectoryEntry.setDirectoryEntryBase(Transformer.getBaseDirectoryEntryFromCommandType(command));
        if (command.getUserCertificate() != null) {
            createDirectoryEntry.setUserCertificates(Transformer.getUserCertificates(command.getUserCertificate()));
        }
        return createDirectoryEntry;
    }

    private static List<UserCertificate> getUserCertificates(UserCertificateType userCertificateType) {
        ArrayList<UserCertificate> userCertificateList = new ArrayList<UserCertificate>();
        UserCertificate userCertificate = new UserCertificate();
        if (userCertificateType.getDn() != null) {
            userCertificate.setDn(Transformer.getDnFromDnType(userCertificateType.getDn()));
        }
        userCertificate.setTelematikID(userCertificateType.getTelematikID());
        if (userCertificateType.getUsage().size() != 0) {
            for (String usage : userCertificateType.getUsage()) {
                userCertificate.addUsageItem(UserCertificate.UsageEnum.fromValue(usage));
            }
        }
        userCertificate.setDescription(userCertificateType.getDescription());
        if (StringUtils.isNoneBlank(userCertificateType.getUserCertificate())) {
            userCertificate.setUserCertificate(userCertificateType.getUserCertificate().replaceAll("\\n", ""));
        }
        userCertificateList.add(userCertificate);
        return userCertificateList;
    }
}

