/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command;

import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionCollection;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import generated.CommandType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionController {
    private Logger LOG = LoggerFactory.getLogger(ExecutionController.class);

    public void execute(List<CommandType> commandList) {
        HashMap<String, Boolean> report = new HashMap<String, Boolean>();
        this.loadCommands(commandList);
        this.LOG.debug("Execution -> Run executions");
        boolean correctExecution = true;
        for (ExecutionBase executor : ExecutionCollection.getInstance().getExecutors()) {
            String executorName = this.extractExecutorName(executor);
            if (!executor.executeCommands()) {
                correctExecution = false;
                report.put(executorName, false);
                this.LOG.error("Error while execute commands in " + executorName);
            } else {
                report.put(executorName, true);
                this.LOG.debug("All commands of " + executorName + " operated correctly");
            }
            if (executor.postCheck()) continue;
            throw new CommandException("Command executed, but postcheck failed!");
        }
        this.logReport(report, correctExecution);
    }

    private String extractExecutorName(ExecutionBase executor) {
        String[] splitClass = executor.getClass().getName().split("\\.");
        return splitClass[splitClass.length - 1];
    }

    private void logReport(Map<String, Boolean> report, boolean correctExecution) {
        for (String key : report.keySet()) {
            this.LOG.info(report.get(key) + " <-- All executions for " + key + " run correctly");
        }
        Object path = System.getProperties().getProperty("l4j.logDir") == null ? System.getProperties().getProperty("java.io.tmpdir") + "logs" : System.getProperties().getProperty("l4j.logDir");
        this.LOG.info("Execution -> All executions done" + (String)(correctExecution ? " correctly" : ". Some commands failed. Please look at the logfile at " + (String)path));
    }

    private void loadCommands(List<CommandType> commandList) {
        this.LOG.debug("Execution -> Precheck started");
        boolean commandError = false;
        for (CommandType command : commandList) {
            boolean unknownCommand = true;
            for (ExecutionBase specificExecutor : ExecutionCollection.getInstance().getExecutors()) {
                if (!specificExecutor.canHandleCommand(CommandNamesEnum.getEntry(command.getName()))) continue;
                unknownCommand = false;
                if (specificExecutor.preCheck(command)) continue;
                commandError = true;
            }
            if (!unknownCommand) continue;
            this.LOG.error("Unknown command " + command.getName() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
            commandError = true;
        }
        if (commandError) {
            throw new CommandException("Commands not executed, preCheck failed!");
        }
        this.LOG.debug("Execution -> Precheck successful");
    }

    public boolean reorder(CommandType command) {
        for (ExecutionBase specificExecutor : ExecutionCollection.getInstance().getExecutors()) {
            if (!specificExecutor.canHandleCommand(CommandNamesEnum.getEntry(command.getName()))) continue;
            return specificExecutor.preCheck(command);
        }
        return false;
    }
}

