/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command;

import de.gematik.ti.epa.vzd.gemClient.exceptions.ReadException;
import de.gematik.ti.epa.vzd.gemClient.invoker.ConfigHandler;
import generated.CommandListType;
import generated.CommandType;
import generated.ObjectFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CommandsBuilder {
    private JAXBContext jaxbContext;
    private Logger LOGGER = LoggerFactory.getLogger(CommandsBuilder.class);
    private static DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();

    public CommandsBuilder() {
        try {
            this.jaxbContext = JAXBContext.newInstance(ObjectFactory.class);
        }
        catch (JAXBException e) {
            throw new ReadException("Error occurred by creating JAXBContext");
        }
    }

    public List<CommandType> buildCommands() {
        ConfigHandler configHandler = ConfigHandler.getInstance();
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            Document doc = builderFactory.newDocumentBuilder().parse(new File(configHandler.getCommandsPath()));
            Object obj = unmarshaller.unmarshal(doc);
            Object commands = ((JAXBElement)obj).getValue();
            if (commands instanceof CommandListType) {
                CommandListType commandList = (CommandListType)commands;
                this.LOGGER.debug("Commands have been build");
                return commandList.getCommand();
            }
        }
        catch (JAXBException | ParserConfigurationException | SAXException e) {
            throw new ReadException("An error have been occurred while reading your command file. Please check if this file is a valid .xml file");
        }
        catch (IOException e) {
            throw new ReadException("A problem with your named file have occurred. Please if check " + configHandler.getCommandsPath() + " exist");
        }
        return null;
    }
}

