/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.client.model;

import com.google.gson.annotations.SerializedName;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class BaseDirectoryEntry {
    public static final String SERIALIZED_NAME_DN = "dn";
    @SerializedName(value="dn")
    private DistinguishedName dn;
    public static final String SERIALIZED_NAME_GIVEN_NAME = "givenName";
    @SerializedName(value="givenName")
    private String givenName;
    public static final String SERIALIZED_NAME_SN = "sn";
    @SerializedName(value="sn")
    private String sn;
    public static final String SERIALIZED_NAME_CN = "cn";
    @SerializedName(value="cn")
    private String cn;
    public static final String SERIALIZED_NAME_DISPLAY_NAME = "displayName";
    @SerializedName(value="displayName")
    private String displayName;
    public static final String SERIALIZED_NAME_STREET_ADDRESS = "streetAddress";
    @SerializedName(value="streetAddress")
    private String streetAddress;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postalCode";
    @SerializedName(value="postalCode")
    private String postalCode;
    public static final String SERIALIZED_NAME_LOCALITY_NAME = "localityName";
    @SerializedName(value="localityName")
    private String localityName;
    public static final String SERIALIZED_NAME_STATE_OR_PROVINCE_NAME = "stateOrProvinceName";
    @SerializedName(value="stateOrProvinceName")
    private String stateOrProvinceName;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_ORGANIZATION = "organization";
    @SerializedName(value="organization")
    private String organization;
    public static final String SERIALIZED_NAME_OTHER_NAME = "otherName";
    @SerializedName(value="otherName")
    private String otherName;
    public static final String SERIALIZED_NAME_SPECIALIZATION = "specialization";
    @SerializedName(value="specialization")
    private List<String> specialization = null;
    public static final String SERIALIZED_NAME_DOMAIN_I_D = "domainID";
    @SerializedName(value="domainID")
    private List<String> domainID = null;
    public static final String SERIALIZED_NAME_PERSONAL_ENTRY = "personalEntry";
    @SerializedName(value="personalEntry")
    private Boolean personalEntry;
    public static final String SERIALIZED_NAME_DATA_FROM_AUTHORITY = "dataFromAuthority";
    @SerializedName(value="dataFromAuthority")
    private Boolean dataFromAuthority;

    public BaseDirectoryEntry dn(DistinguishedName dn) {
        this.dn = dn;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DistinguishedName getDn() {
        return this.dn;
    }

    public void setDn(DistinguishedName dn) {
        this.dn = dn;
    }

    @Nullable
    @ApiModelProperty(example="Vorname", value="HBA: Vorname, obligatorisch, wird aus dem Zertifikat \u00c3\u00bcbernommen / SMC-B: nicht verwendet")
    public String getGivenName() {
        return this.givenName;
    }

    @Nullable
    @ApiModelProperty(example="Nachname", value="HBA: Name, obligatorisch, wird aus dem Zertifikat \u00c3\u00bcbernommen / SMC-B: nicht verwendet")
    public String getSn() {
        return this.sn;
    }

    @ApiModelProperty(example="Vorname Nachname", required=true, value="HBA: Vorname und Nachname / SMC-B: Bezeichner: Name Wird vom VZD aus dem Zertifikatsattribut commonName \u00c3\u00bcbernommen.")
    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public BaseDirectoryEntry displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Vorname Nachname", value="Anzeigename, kann ge\u00c3\u00a4ndert werden. Dieses Attribut wird genutzt um den Namen der Organisation gegen\u00c3\u00bcber dem Anwender darzustellen (Verwendung als Filter-Attribut um die Suche einzuschr\u00c3\u00a4nken und bei der Darstellung des Ergebnisses). Der Wert wird von der pflegenden Stelle festgelegt.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public BaseDirectoryEntry streetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Friedrichstra\u00c3\u0178e 136", value="Stra\u00c3\u0178e und Hausnummer Der Wert wird von der pflegenden Stelle festgelegt")
    public String getStreetAddress() {
        return this.streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public BaseDirectoryEntry postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10117", value="Postleitzahl Der Wert wird von der pflegenden Stelle festgelegt")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public BaseDirectoryEntry localityName(String localityName) {
        this.localityName = localityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Berlin", value="Ort Der Wert wird von der pflegenden Stelle festgelegt")
    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String localityName) {
        this.localityName = localityName;
    }

    public BaseDirectoryEntry stateOrProvinceName(String stateOrProvinceName) {
        this.stateOrProvinceName = stateOrProvinceName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Berlin", value="Bundesland Der Wert wird von der pflegenden Stelle festgelegt")
    public String getStateOrProvinceName() {
        return this.stateOrProvinceName;
    }

    public void setStateOrProvinceName(String stateOrProvinceName) {
        this.stateOrProvinceName = stateOrProvinceName;
    }

    public BaseDirectoryEntry title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HBA: Titel, optional / SMC-B: nicht verwendet")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BaseDirectoryEntry organization(String organization) {
        this.organization = organization;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12345670", value="Organisation Der Wert wird von der pflegenden Stelle festgelegt")
    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public BaseDirectoryEntry otherName(String otherName) {
        this.otherName = otherName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Anderer Name. Wird vom VZD aus dem Zertifikatsattribut otherName \u00c3\u00bcbernommen.")
    public String getOtherName() {
        return this.otherName;
    }

    public void setOtherName(String otherName) {
        this.otherName = otherName;
    }

    public BaseDirectoryEntry specialization(List<String> specialization) {
        this.specialization = specialization;
        return this;
    }

    public BaseDirectoryEntry addSpecializationItem(String specializationItem) {
        if (this.specialization == null) {
            this.specialization = new ArrayList<String>();
        }
        this.specialization.add(specializationItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fachgebiet Der Wert wird von der pflegenden Stelle festgelegt")
    public List<String> getSpecialization() {
        return this.specialization;
    }

    public void setSpecialization(List<String> specialization) {
        this.specialization = specialization;
    }

    public BaseDirectoryEntry domainID(List<String> domainID) {
        this.domainID = domainID;
        return this;
    }

    public BaseDirectoryEntry addDomainIDItem(String domainIDItem) {
        if (this.domainID == null) {
            this.domainID = new ArrayList<String>();
        }
        this.domainID.add(domainIDItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u00c3\u201erzte: Betriebsst\u00c3\u00a4ttennummer Der Wert wird aus dem Zertifikat \u00c3\u00bcbernommen (Attribut organizationName)")
    public List<String> getDomainID() {
        return this.domainID;
    }

    public void setDomainID(List<String> domainID) {
        this.domainID = domainID;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Wird vom VZD eingetragen / Wert == TRUE, wenn alle Zertifikate den entryType 1 haben (Berufsgruppe), Wert == FALSE sonst")
    public Boolean getPersonalEntry() {
        return this.personalEntry;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Wird vom VZD eingetragen / Wert == TRUE, wenn der Verzeichnisdienst_Eintrag von dem Kartenherausgeber geschrieben wurde, Wert == FALSE sonst")
    public Boolean getDataFromAuthority() {
        return this.dataFromAuthority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseDirectoryEntry baseDirectoryEntry = (BaseDirectoryEntry)o;
        return Objects.equals(this.dn, baseDirectoryEntry.dn) && Objects.equals(this.givenName, baseDirectoryEntry.givenName) && Objects.equals(this.sn, baseDirectoryEntry.sn) && Objects.equals(this.cn, baseDirectoryEntry.cn) && Objects.equals(this.displayName, baseDirectoryEntry.displayName) && Objects.equals(this.streetAddress, baseDirectoryEntry.streetAddress) && Objects.equals(this.postalCode, baseDirectoryEntry.postalCode) && Objects.equals(this.localityName, baseDirectoryEntry.localityName) && Objects.equals(this.stateOrProvinceName, baseDirectoryEntry.stateOrProvinceName) && Objects.equals(this.title, baseDirectoryEntry.title) && Objects.equals(this.organization, baseDirectoryEntry.organization) && Objects.equals(this.otherName, baseDirectoryEntry.otherName) && Objects.equals(this.specialization, baseDirectoryEntry.specialization) && Objects.equals(this.domainID, baseDirectoryEntry.domainID) && Objects.equals(this.personalEntry, baseDirectoryEntry.personalEntry) && Objects.equals(this.dataFromAuthority, baseDirectoryEntry.dataFromAuthority);
    }

    public int hashCode() {
        return Objects.hash(this.dn, this.givenName, this.sn, this.cn, this.displayName, this.streetAddress, this.postalCode, this.localityName, this.stateOrProvinceName, this.title, this.organization, this.otherName, this.specialization, this.domainID, this.personalEntry, this.dataFromAuthority);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseDirectoryEntry {\n");
        sb.append("    dn: ").append(this.toIndentedString(this.dn)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    sn: ").append(this.toIndentedString(this.sn)).append("\n");
        sb.append("    cn: ").append(this.toIndentedString(this.cn)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    streetAddress: ").append(this.toIndentedString(this.streetAddress)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    localityName: ").append(this.toIndentedString(this.localityName)).append("\n");
        sb.append("    stateOrProvinceName: ").append(this.toIndentedString(this.stateOrProvinceName)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    otherName: ").append(this.toIndentedString(this.otherName)).append("\n");
        sb.append("    specialization: ").append(this.toIndentedString(this.specialization)).append("\n");
        sb.append("    domainID: ").append(this.toIndentedString(this.domainID)).append("\n");
        sb.append("    personalEntry: ").append(this.toIndentedString(this.personalEntry)).append("\n");
        sb.append("    dataFromAuthority: ").append(this.toIndentedString(this.dataFromAuthority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

