/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.client.api;

import com.google.gson.reflect.TypeToken;
import de.gematik.ti.epa.vzd.client.invoker.ApiCallback;
import de.gematik.ti.epa.vzd.client.invoker.ApiClient;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.invoker.Configuration;
import de.gematik.ti.epa.vzd.client.invoker.Pair;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import de.gematik.ti.epa.vzd.client.model.UserCertificate;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class CertificateAdministrationApi {
    private ApiClient localVarApiClient;

    public CertificateAdministrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CertificateAdministrationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addDirectoryEntryCertificateCall(String uid, UserCertificate userCertificate, ApiCallback _callback) throws ApiException {
        UserCertificate localVarPostBody = userCertificate;
        String localVarPath = "/DirectoryEntries/{uid}/Certificates".replaceAll("\\{uid\\}", this.localVarApiClient.escapeString(uid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addDirectoryEntryCertificateValidateBeforeCall(String uid, UserCertificate userCertificate, ApiCallback _callback) throws ApiException {
        if (uid == null) {
            throw new ApiException("Missing the required parameter 'uid' when calling addDirectoryEntryCertificate(Async)");
        }
        if (userCertificate == null) {
            throw new ApiException("Missing the required parameter 'userCertificate' when calling addDirectoryEntryCertificate(Async)");
        }
        Call localVarCall = this.addDirectoryEntryCertificateCall(uid, userCertificate, _callback);
        return localVarCall;
    }

    public DistinguishedName addDirectoryEntryCertificate(String uid, UserCertificate userCertificate) throws ApiException {
        ApiResponse<DistinguishedName> localVarResp = this.addDirectoryEntryCertificateWithHttpInfo(uid, userCertificate);
        return localVarResp.getData();
    }

    public ApiResponse<DistinguishedName> addDirectoryEntryCertificateWithHttpInfo(String uid, UserCertificate userCertificate) throws ApiException {
        Call localVarCall = this.addDirectoryEntryCertificateValidateBeforeCall(uid, userCertificate, null);
        Type localVarReturnType = new TypeToken<DistinguishedName>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addDirectoryEntryCertificateAsync(String uid, UserCertificate userCertificate, ApiCallback<DistinguishedName> _callback) throws ApiException {
        Call localVarCall = this.addDirectoryEntryCertificateValidateBeforeCall(uid, userCertificate, _callback);
        Type localVarReturnType = new TypeToken<DistinguishedName>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDirectoryEntryCertificateCall(String uid, String certificateEntryID, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/DirectoryEntries/{uid}/Certificates/{certificateEntryID}".replaceAll("\\{uid\\}", this.localVarApiClient.escapeString(uid.toString())).replaceAll("\\{certificateEntryID\\}", this.localVarApiClient.escapeString(certificateEntryID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDirectoryEntryCertificateValidateBeforeCall(String uid, String certificateEntryID, ApiCallback _callback) throws ApiException {
        if (uid == null) {
            throw new ApiException("Missing the required parameter 'uid' when calling deleteDirectoryEntryCertificate(Async)");
        }
        if (certificateEntryID == null) {
            throw new ApiException("Missing the required parameter 'certificateEntryID' when calling deleteDirectoryEntryCertificate(Async)");
        }
        Call localVarCall = this.deleteDirectoryEntryCertificateCall(uid, certificateEntryID, _callback);
        return localVarCall;
    }

    public void deleteDirectoryEntryCertificate(String uid, String certificateEntryID) throws ApiException {
        this.deleteDirectoryEntryCertificateWithHttpInfo(uid, certificateEntryID);
    }

    public ApiResponse<Void> deleteDirectoryEntryCertificateWithHttpInfo(String uid, String certificateEntryID) throws ApiException {
        Call localVarCall = this.deleteDirectoryEntryCertificateValidateBeforeCall(uid, certificateEntryID, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteDirectoryEntryCertificateAsync(String uid, String certificateEntryID, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteDirectoryEntryCertificateValidateBeforeCall(uid, certificateEntryID, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call modifyDirectoryEntryCertificateCall(String uid, String certificateEntryID, UserCertificate userCertificate, ApiCallback _callback) throws ApiException {
        UserCertificate localVarPostBody = userCertificate;
        String localVarPath = "/DirectoryEntries/{uid}/Certificates/{certificateEntryID}".replaceAll("\\{uid\\}", this.localVarApiClient.escapeString(uid.toString())).replaceAll("\\{certificateEntryID\\}", this.localVarApiClient.escapeString(certificateEntryID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyDirectoryEntryCertificateValidateBeforeCall(String uid, String certificateEntryID, UserCertificate userCertificate, ApiCallback _callback) throws ApiException {
        if (uid == null) {
            throw new ApiException("Missing the required parameter 'uid' when calling modifyDirectoryEntryCertificate(Async)");
        }
        if (certificateEntryID == null) {
            throw new ApiException("Missing the required parameter 'certificateEntryID' when calling modifyDirectoryEntryCertificate(Async)");
        }
        if (userCertificate == null) {
            throw new ApiException("Missing the required parameter 'userCertificate' when calling modifyDirectoryEntryCertificate(Async)");
        }
        Call localVarCall = this.modifyDirectoryEntryCertificateCall(uid, certificateEntryID, userCertificate, _callback);
        return localVarCall;
    }

    public UserCertificate modifyDirectoryEntryCertificate(String uid, String certificateEntryID, UserCertificate userCertificate) throws ApiException {
        ApiResponse<UserCertificate> localVarResp = this.modifyDirectoryEntryCertificateWithHttpInfo(uid, certificateEntryID, userCertificate);
        return localVarResp.getData();
    }

    public ApiResponse<UserCertificate> modifyDirectoryEntryCertificateWithHttpInfo(String uid, String certificateEntryID, UserCertificate userCertificate) throws ApiException {
        Call localVarCall = this.modifyDirectoryEntryCertificateValidateBeforeCall(uid, certificateEntryID, userCertificate, null);
        Type localVarReturnType = new TypeToken<UserCertificate>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyDirectoryEntryCertificateAsync(String uid, String certificateEntryID, UserCertificate userCertificate, ApiCallback<UserCertificate> _callback) throws ApiException {
        Call localVarCall = this.modifyDirectoryEntryCertificateValidateBeforeCall(uid, certificateEntryID, userCertificate, _callback);
        Type localVarReturnType = new TypeToken<UserCertificate>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readDirectoryCertificatesCall(String uid, String certificateEntryID, String entryType, String telematikID, String professionOID, String usage, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/DirectoryEntries/Certificates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if (certificateEntryID != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("certificateEntryID", certificateEntryID));
        }
        if (entryType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("entryType", entryType));
        }
        if (telematikID != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("telematikID", telematikID));
        }
        if (professionOID != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("professionOID", professionOID));
        }
        if (usage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("usage", usage));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readDirectoryCertificatesValidateBeforeCall(String uid, String certificateEntryID, String entryType, String telematikID, String professionOID, String usage, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.readDirectoryCertificatesCall(uid, certificateEntryID, entryType, telematikID, professionOID, usage, _callback);
        return localVarCall;
    }

    public List<UserCertificate> readDirectoryCertificates(String uid, String certificateEntryID, String entryType, String telematikID, String professionOID, String usage) throws ApiException {
        ApiResponse<List<UserCertificate>> localVarResp = this.readDirectoryCertificatesWithHttpInfo(uid, certificateEntryID, entryType, telematikID, professionOID, usage);
        return localVarResp.getData();
    }

    public ApiResponse<List<UserCertificate>> readDirectoryCertificatesWithHttpInfo(String uid, String certificateEntryID, String entryType, String telematikID, String professionOID, String usage) throws ApiException {
        Call localVarCall = this.readDirectoryCertificatesValidateBeforeCall(uid, certificateEntryID, entryType, telematikID, professionOID, usage, null);
        Type localVarReturnType = new TypeToken<List<UserCertificate>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readDirectoryCertificatesAsync(String uid, String certificateEntryID, String entryType, String telematikID, String professionOID, String usage, ApiCallback<List<UserCertificate>> _callback) throws ApiException {
        Call localVarCall = this.readDirectoryCertificatesValidateBeforeCall(uid, certificateEntryID, entryType, telematikID, professionOID, usage, _callback);
        Type localVarReturnType = new TypeToken<List<UserCertificate>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

