/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.invoker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.gematik.ti.epa.vzd.client.invoker.ApiClient;
import de.gematik.ti.epa.vzd.client.invoker.JSON;
import de.gematik.ti.epa.vzd.client.invoker.auth.Authentication;
import de.gematik.ti.epa.vzd.client.invoker.auth.HttpBasicAuth;
import de.gematik.ti.epa.vzd.client.invoker.auth.OAuth;
import de.gematik.ti.epa.vzd.client.invoker.auth.OAuthFlow;
import de.gematik.ti.epa.vzd.client.invoker.auth.RetryingOAuth;
import de.gematik.ti.epa.vzd.gemClient.exceptions.GemClientException;
import de.gematik.ti.epa.vzd.gemClient.invoker.ConfigHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GemApiClient
extends ApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(GemApiClient.class);
    private String retryingOAuthPath;
    private Map<String, Authentication> authentications;
    private LocalDateTime tokenvalidationDate;

    public GemApiClient() {
        this.init();
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public GemApiClient(String clientId) {
        this(clientId, null, null);
    }

    public GemApiClient(String clientId, Map<String, String> parameters) {
        this(clientId, null, parameters);
    }

    public GemApiClient(String clientId, String clientSecret, Map<String, String> parameters) {
        this.init();
        RetryingOAuth retryingOAuth = new RetryingOAuth(this.retryingOAuthPath, clientId, OAuthFlow.application, clientSecret, parameters);
        this.authentications.put("OAuth2", retryingOAuth);
        this.getHttpClient().interceptors().add(retryingOAuth);
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    private void init() {
        ConfigHandler configHandler = ConfigHandler.getInstance();
        this.setBasePath(configHandler.getBasePath());
        this.retryingOAuthPath = configHandler.getRetryingOAuthPath();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addNetworkInterceptor(this.getProgressInterceptor());
        this.setHttpClient(builder.build());
        this.setVerifyingSsl(true);
        this.setJSON(new JSON());
        this.setUserAgent("OpenAPI-Generator/1.0.0/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("HttpBasicAuth", this.getHttpBasicAuthFromFile(configHandler.getCredentialPath()));
        try {
            this.authentications.put("OAuth", this.getNewOAuth2Token());
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            throw new ExceptionInInitializerError("Error while getting Token");
        }
    }

    private OAuth getNewOAuth2Token() throws OAuthProblemException, OAuthSystemException {
        LOG.debug("Trying to get new access token");
        HttpBasicAuth baseAuth = (HttpBasicAuth)this.getAuthentications().get("HttpBasicAuth");
        OAuthClientRequest request = OAuthClientRequest.tokenLocation(this.retryingOAuthPath).setClientId(baseAuth.getUsername()).setClientSecret(baseAuth.getPassword()).setGrantType(GrantType.CLIENT_CREDENTIALS).buildBodyMessage();
        request.setHeader("Accept", "application/json");
        OAuthClient oAuthClient = new OAuthClient(new URLConnectionClient());
        OAuthJSONAccessTokenResponse oAuthResponse = oAuthClient.accessToken(request, OAuthJSONAccessTokenResponse.class);
        JsonObject jObj = new JsonParser().parse(oAuthResponse.getBody()).getAsJsonObject();
        OAuth oAuth = new OAuth();
        oAuth.setAccessToken(jObj.get("access_token").toString().replaceAll("\"", ""));
        this.setTokenValidation(jObj.get("expires_in").toString());
        LOG.debug("Requesting new OAuth2 token successful");
        return oAuth;
    }

    private void setTokenValidation(String expires_in) {
        int seconds = Integer.parseInt(expires_in);
        int secureSeconds = (int)((double)seconds * 0.9);
        this.tokenvalidationDate = LocalDateTime.now().plusSeconds(secureSeconds);
    }

    public boolean validateToken() {
        if (LocalDateTime.now().isBefore(this.tokenvalidationDate)) {
            return true;
        }
        try {
            this.getNewOAuth2Token();
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            throw new GemClientException("Requesting a new OAuth2 token failed.", e);
        }
        return LocalDateTime.now().isBefore(this.tokenvalidationDate);
    }

    private HttpBasicAuth getHttpBasicAuthFromFile(String arg) {
        String client_id = "";
        String client_secret = "";
        File file = new File(arg);
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            while (line != null) {
                String[] param = line.split("=");
                switch (param[0]) {
                    case "id": {
                        client_id = param[1];
                        break;
                    }
                    case "secret": {
                        client_secret = param[1];
                        break;
                    }
                }
                line = br.readLine();
            }
            HttpBasicAuth basicAuth = new HttpBasicAuth();
            basicAuth.setPassword(client_secret);
            basicAuth.setUsername(client_id);
            return basicAuth;
        }
        catch (IOException e) {
            LOG.error("The named file on path " + file.getAbsolutePath() + " could not be accessed");
            throw new IllegalArgumentException("The named file on path " + file.getAbsolutePath() + " could not be accessed");
        }
    }

    @Override
    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    @Override
    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }
}

