/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.invoker;

import de.gematik.ti.epa.vzd.gemClient.exceptions.GemClientException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigHandler.class);
    private static final String BASE_PATH = "base";
    private static final String RETRY_OAUTH = "retryingOAuth";
    private static final String COMMANDS = "commands";
    private static ConfigHandler configHandler = null;
    private String configPath;
    private String basePath;
    private String credentialPath;
    private String commandsPath;
    private String retryingOAuthPath;

    private ConfigHandler() {
    }

    public static ConfigHandler getInstance() {
        if (configHandler == null) {
            throw new GemClientException("A ConfigHandler have to be initialized first");
        }
        return configHandler;
    }

    public static ConfigHandler init(String[] args) {
        if (configHandler == null) {
            configHandler = new ConfigHandler();
            block10: for (int iIndex = 0; iIndex < args.length; ++iIndex) {
                switch (args[iIndex]) {
                    case "-p": {
                        ConfigHandler.configHandler.configPath = new File(args[iIndex + 1]).getAbsolutePath();
                        configHandler.setParams(ConfigHandler.configHandler.configPath);
                        continue block10;
                    }
                    case "-c": {
                        ConfigHandler.configHandler.credentialPath = new File(args[iIndex + 1]).getAbsolutePath();
                        continue block10;
                    }
                    case "-b": {
                        ConfigHandler.configHandler.commandsPath = new File(args[iIndex + 1]).getAbsolutePath();
                        continue block10;
                    }
                }
            }
        } else {
            throw new GemClientException("Configurations are only allowed to set once");
        }
        if (StringUtils.isBlank(ConfigHandler.configHandler.credentialPath) || StringUtils.isBlank(ConfigHandler.configHandler.configPath)) {
            LOG.error("At least CredentialPath or ConfigPath is missing and have to be set");
            throw new GemClientException("At least CredentialPath or ConfigPath is missing and have to be set");
        }
        LOG.debug("Configurations have been set");
        return configHandler;
    }

    private void setParams(String arg) {
        File file = new File(arg);
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            while (line != null) {
                if (StringUtils.isNotBlank(line) && line.contains("=")) {
                    String[] param = line.split("=");
                    String name = param[0];
                    String value = param[1];
                    switch (name) {
                        case "base": {
                            ConfigHandler.configHandler.basePath = value;
                            break;
                        }
                        case "retryingOAuth": {
                            ConfigHandler.configHandler.retryingOAuthPath = value;
                            break;
                        }
                        case "commands": {
                            if (!StringUtils.isBlank(ConfigHandler.configHandler.commandsPath)) break;
                            ConfigHandler.configHandler.commandsPath = new File(value).getAbsolutePath();
                            break;
                        }
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            LOG.error("File not found at " + file.getAbsolutePath());
            throw new IllegalArgumentException("No access to given file " + file.getAbsolutePath());
        }
        if (StringUtils.isBlank(ConfigHandler.configHandler.retryingOAuthPath)) {
            LOG.error("No authorization server named");
            throw new GemClientException("No authorization server named");
        }
        if (StringUtils.isBlank(ConfigHandler.configHandler.basePath)) {
            LOG.error("No vzd server named");
            throw new GemClientException("No server named");
        }
    }

    public static void setConfigHandler(ConfigHandler setConfigHandler) {
        configHandler = setConfigHandler;
    }

    public String getRetryingOAuthPath() {
        return this.retryingOAuthPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getCredentialPath() {
        return this.credentialPath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getCommandsPath() {
        return this.commandsPath;
    }
}

