/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.api.CertificateAdministrationApi;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.model.UserCertificate;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.GemStringUtils;
import de.gematik.ti.epa.vzd.gemClient.api.GemCertificateAdministrationApi;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.AddDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import generated.UserCertificateType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadDirEntryCertExecution
extends ExecutionBase {
    private CertificateAdministrationApi certificateAdministrationApi;
    private Logger LOG = LoggerFactory.getLogger(AddDirEntryExecution.class);

    public ReadDirEntryCertExecution(GemApiClient api) {
        super(api, CommandNamesEnum.READ_DIR_CERT);
        this.certificateAdministrationApi = new GemCertificateAdministrationApi(this.apiClient);
    }

    @Override
    public boolean checkValidation(CommandType command) {
        UserCertificateType cert = command.getUserCertificate();
        if (cert != null) {
            ArrayList<String> params = new ArrayList<String>();
            if (command.getDn() != null) {
                params.add(command.getDn().getUid());
            }
            params.add(cert.getEntryType());
            params.add(cert.getTelematikID());
            params.add(cert.getProfessionOID());
            if (cert.getUsage().size() != 0) {
                params.add("usage Vorhanden");
            }
            for (String param : params) {
                if (StringUtils.isBlank(param)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean executeCommands() {
        boolean runSuccessful = true;
        if (this.commands.size() == 0) {
            return true;
        }
        for (CommandType command : this.commands) {
            try {
                for (UserCertificate userCertificate : this.executeCommand(command).getData()) {
                    this.LOG.debug("Entry found: " + userCertificate);
                }
            }
            catch (Exception ex) {
                this.LOG.error("Read directory entry execution failed\n" + Transformer.getCreateDirectoryEntry(command));
                runSuccessful = false;
            }
        }
        return runSuccessful;
    }

    protected ApiResponse<List<UserCertificate>> executeCommand(CommandType command) throws ApiException {
        UserCertificateType cert = command.getUserCertificate();
        String uid = null;
        String cn = null;
        if (cert.getDn() != null) {
            uid = cert.getDn().getUid();
            cn = cert.getDn().getCn();
        }
        String entryType = cert.getEntryType();
        String telematikID = cert.getTelematikID();
        String professionOID = cert.getProfessionOID();
        String usage = null;
        if (cert.getUsage().size() != 0) {
            usage = GemStringUtils.listToString(cert.getUsage());
        }
        ApiResponse<List<UserCertificate>> response = this.certificateAdministrationApi.readDirectoryCertificatesWithHttpInfo(uid, cn, entryType, telematikID, professionOID, usage);
        return response;
    }

    @Override
    public boolean postCheck() {
        try {
            super.postCheck();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

