/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.api.DirectoryEntryAdministrationApi;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.model.BaseDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.api.GemDirectoryEntryAdministrationApi;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDirEntryExecution
extends ExecutionBase {
    private Logger LOG = LoggerFactory.getLogger(ModifyDirEntryExecution.class);
    private final DirectoryEntryAdministrationApi directoryEntryAdministrationApi = new GemDirectoryEntryAdministrationApi(this.apiClient);

    public ModifyDirEntryExecution(GemApiClient api) {
        super(api, CommandNamesEnum.MOD_DIR_ENTRY);
    }

    @Override
    public boolean checkValidation(CommandType command) {
        boolean check = true;
        if (command.getDn() != null) {
            if (StringUtils.isBlank(command.getDn().getUid())) {
                this.LOG.error("Missing argument -> uid for command " + command.getName() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
                check = false;
            }
        } else {
            this.LOG.error("Missing element \"dn\" " + command.getName() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
            check = false;
        }
        return check;
    }

    @Override
    public boolean executeCommands() {
        boolean runSuccessful = true;
        if (this.commands.size() == 0) {
            return true;
        }
        for (CommandType command : this.commands) {
            if (this.isEntryPresent(command)) {
                try {
                    this.executeCommand(command);
                }
                catch (Exception ex) {
                    this.LOG.error("An error have occured: " + ex.getMessage());
                    runSuccessful = false;
                }
                continue;
            }
            runSuccessful = this.doAdd(command);
        }
        return runSuccessful;
    }

    protected ApiResponse<DistinguishedName> executeCommand(CommandType command) throws ApiException {
        this.apiClient.validateToken();
        BaseDirectoryEntry baseDirectoryEntry = Transformer.getBaseDirectoryEntryFromCommandType(command);
        ApiResponse<DistinguishedName> response = this.directoryEntryAdministrationApi.modifyDirectoryEntryWithHttpInfo(command.getDn().getUid(), baseDirectoryEntry);
        if (response.getStatusCode() != 200) {
            throw new CommandException("Modify directory entry execution failed. Response-Status was: " + response.getStatusCode() + "\n" + Transformer.getBaseDirectoryEntryFromCommandType(command));
        }
        this.LOG.debug("Modify directory entry execution successful operated\n" + response.getData());
        return response;
    }

    private boolean doAdd(CommandType command) {
        this.LOG.info("Ended here!");
        return true;
    }

    @Override
    public boolean postCheck() {
        try {
            super.postCheck();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

