/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.AddDirEntryCertExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.AddDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.DeleteDirEntryCertExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.DeleteDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ModifyDirEntryCertExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ModifyDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ReadDirEntryCertExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ReadDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionCollection {
    private final ReadDirEntryExecution readDirEntryExecution;
    private final ReadDirEntryCertExecution readDirEntryCertExecution;
    private final AddDirEntryExecution addDirEntryExecution;
    private final AddDirEntryCertExecution addDirEntryCertExecution;
    private final ModifyDirEntryExecution modifyDirEntryExecution;
    private final ModifyDirEntryCertExecution modifyDirEntryCertExecution;
    private static Logger LOG = LoggerFactory.getLogger(ExecutionCollection.class);
    private ArrayList<ExecutionBase> specificExecutors = new ArrayList();
    private static ExecutionCollection executions;

    public static ExecutionCollection getInstance() {
        if (executions == null) {
            throw new InstantiationError("Please instance a executor first. It needs an ApiClient");
        }
        return executions;
    }

    public static ExecutionCollection init(GemApiClient apiClient) {
        if (executions != null) {
            LOG.error("Error occurred while initializing executions. Executor is already instanced");
            throw new InstantiationError("Executor is already instanced");
        }
        executions = new ExecutionCollection(apiClient);
        LOG.debug("Executions have been initialized correctly");
        return executions;
    }

    private ExecutionCollection(GemApiClient apiClient) {
        this.readDirEntryExecution = new ReadDirEntryExecution(apiClient);
        this.readDirEntryCertExecution = new ReadDirEntryCertExecution(apiClient);
        this.addDirEntryExecution = new AddDirEntryExecution(apiClient);
        this.addDirEntryCertExecution = new AddDirEntryCertExecution(apiClient);
        this.modifyDirEntryExecution = new ModifyDirEntryExecution(apiClient);
        this.modifyDirEntryCertExecution = new ModifyDirEntryCertExecution(apiClient);
        this.specificExecutors.add(this.readDirEntryExecution);
        this.specificExecutors.add(this.addDirEntryExecution);
        this.specificExecutors.add(this.modifyDirEntryExecution);
        this.specificExecutors.add(new DeleteDirEntryExecution(apiClient));
        this.specificExecutors.add(this.readDirEntryCertExecution);
        this.specificExecutors.add(this.addDirEntryCertExecution);
        this.specificExecutors.add(this.modifyDirEntryCertExecution);
        this.specificExecutors.add(new DeleteDirEntryCertExecution(apiClient));
    }

    public List<ExecutionBase> getExecutors() {
        return this.specificExecutors;
    }

    public ReadDirEntryExecution getReadDirEntryExecution() {
        return this.readDirEntryExecution;
    }

    public ReadDirEntryCertExecution getReadDirEntryCertExecution() {
        return this.readDirEntryCertExecution;
    }

    public AddDirEntryExecution getAddDirEntryExecution() {
        return this.addDirEntryExecution;
    }

    public AddDirEntryCertExecution getAddDirEntryCertExecution() {
        return this.addDirEntryCertExecution;
    }

    public ModifyDirEntryExecution getModifyDirEntry() {
        return this.modifyDirEntryExecution;
    }

    public ModifyDirEntryCertExecution getModifyDirEntryCertExecution() {
        return this.modifyDirEntryCertExecution;
    }
}

