/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient.command.commandExecutions;

import de.gematik.ti.epa.vzd.client.api.CertificateAdministrationApi;
import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.invoker.ApiResponse;
import de.gematik.ti.epa.vzd.client.model.BaseDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.CreateDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import de.gematik.ti.epa.vzd.client.model.UserCertificate;
import de.gematik.ti.epa.vzd.gemClient.CommandNamesEnum;
import de.gematik.ti.epa.vzd.gemClient.api.GemCertificateAdministrationApi;
import de.gematik.ti.epa.vzd.gemClient.command.Transformer;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.AddDirEntryExecution;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionBase;
import de.gematik.ti.epa.vzd.gemClient.exceptions.CommandException;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDirEntryCertExecution
extends ExecutionBase {
    private CertificateAdministrationApi certificateAdministrationApi;
    private Logger LOG = LoggerFactory.getLogger(AddDirEntryExecution.class);

    public DeleteDirEntryCertExecution(GemApiClient api) {
        super(api, CommandNamesEnum.DEL_DIR_CERT);
        this.certificateAdministrationApi = new GemCertificateAdministrationApi(this.apiClient);
    }

    @Override
    public boolean checkValidation(CommandType command) {
        String uid = null;
        String cn = null;
        if (command.getUserCertificate() != null && command.getUserCertificate().getDn() != null) {
            uid = command.getUserCertificate().getDn().getUid();
            cn = command.getUserCertificate().getDn().getCn();
        }
        if (StringUtils.isBlank(uid) && command.getDomainID() != null) {
            uid = command.getDn().getUid();
        }
        return !StringUtils.isBlank(uid) && !StringUtils.isBlank(cn);
    }

    @Override
    public boolean executeCommands() {
        boolean runSuccessful = true;
        if (this.commands.size() == 0) {
            return true;
        }
        for (CommandType command : this.commands) {
            System.out.println("Warning isEntryPresent abgeschlatet <- executeCommands " + this.getClass());
            try {
                this.executeCommand(command);
            }
            catch (Exception ex) {
                this.LOG.error("An error have occured: " + ex.getMessage());
                runSuccessful = false;
            }
        }
        return runSuccessful;
    }

    private void executeCommand(CommandType command) {
        this.apiClient.validateToken();
        boolean runSucsessfull = true;
        CreateDirectoryEntry createDirectoryEntry = Transformer.getCreateDirectoryEntry(command);
        for (UserCertificate userCertificate : createDirectoryEntry.getUserCertificates()) {
            try {
                String cn;
                String uid = this.getUid(createDirectoryEntry.getDirectoryEntryBase(), userCertificate);
                ApiResponse<Void> response = this.deleteSingleCertificate(uid, cn = command.getUserCertificate().getDn().getCn());
                if (response.getStatusCode() != 200) continue;
                this.LOG.debug("Certificate successful deleted: \n" + userCertificate);
            }
            catch (ApiException e) {
                runSucsessfull = false;
                this.LOG.error("Something went wrong will adding certificate. Responsecode: " + e.getCode() + " certificate: " + userCertificate.getUserCertificate());
            }
        }
        if (!runSucsessfull) {
            throw new CommandException("At least one certificate could not be added in:\n" + Transformer.getCreateDirectoryEntry(command));
        }
    }

    private String getUid(BaseDirectoryEntry directoryEntryBase, UserCertificate userCertificate) {
        DistinguishedName dn;
        String uidCert = userCertificate.getDn().getUid();
        String uidEntry = null;
        if (directoryEntryBase != null && (dn = directoryEntryBase.getDn()) != null) {
            uidEntry = dn.getUid();
        }
        return uidCert == null ? uidEntry : uidCert;
    }

    private ApiResponse<Void> deleteSingleCertificate(String uid, String certificateEntryId) throws ApiException {
        return this.certificateAdministrationApi.deleteDirectoryEntryCertificateWithHttpInfo(uid, certificateEntryId);
    }

    @Override
    public boolean postCheck() {
        try {
            super.postCheck();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

