/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.gemClient;

import de.gematik.ti.epa.vzd.gemClient.GemStringUtils;
import de.gematik.ti.epa.vzd.gemClient.command.CommandsBuilder;
import de.gematik.ti.epa.vzd.gemClient.command.ExecutionController;
import de.gematik.ti.epa.vzd.gemClient.command.commandExecutions.ExecutionCollection;
import de.gematik.ti.epa.vzd.gemClient.invoker.ConfigHandler;
import de.gematik.ti.epa.vzd.gemClient.invoker.GemApiClient;
import generated.CommandType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        LOG.info("VZD-Client started");
        LOG.info(GemStringUtils.getPic());
        ConfigHandler.init(args);
        Main.start();
    }

    private static void start() {
        ExecutionCollection.init(new GemApiClient());
        List<CommandType> commands = new CommandsBuilder().buildCommands();
        ConfigHandler configHandler = ConfigHandler.getInstance();
        LOG.debug("============ Execution parameter ============");
        LOG.debug("Server: " + configHandler.getBasePath());
        LOG.debug("OAuth Server: " + configHandler.getRetryingOAuthPath());
        LOG.debug("Command data: " + configHandler.getCommandsPath());
        LOG.debug("Commands in progress: " + commands.size());
        LOG.debug("=============================================");
        new ExecutionController().execute(commands);
    }

    private Main() {
    }
}

