/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.ti.epa.vzd.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Jeder Verzeichniseintrag muss mindestens ein Zertifikat enthalten.")
public class UserCertificate {
    public static final String SERIALIZED_NAME_DN = "dn";
    @SerializedName(value="dn")
    private DistinguishedName dn;
    public static final String SERIALIZED_NAME_ENTRY_TYPE = "entryType";
    @SerializedName(value="entryType")
    private String entryType;
    public static final String SERIALIZED_NAME_TELEMATIK_I_D = "telematikID";
    @SerializedName(value="telematikID")
    private String telematikID;
    public static final String SERIALIZED_NAME_PROFESSION_O_I_D = "professionOID";
    @SerializedName(value="professionOID")
    private List<String> professionOID = null;
    public static final String SERIALIZED_NAME_USAGE = "usage";
    @SerializedName(value="usage")
    private List<UsageEnum> usage = null;
    public static final String SERIALIZED_NAME_USER_CERTIFICATE = "userCertificate";
    @SerializedName(value="userCertificate")
    private String userCertificate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;

    public UserCertificate dn(DistinguishedName dn) {
        this.dn = dn;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DistinguishedName getDn() {
        return this.dn;
    }

    public void setDn(DistinguishedName dn) {
        this.dn = dn;
    }

    @Nullable
    @ApiModelProperty(value="Eintragstyp Wird vom VZD anhand der in dem Zertifikat enthaltenen OID (Extension Admission, Attribut ProfessionOID) und der Spalte Eintragstyp in Tab_VZD_Mapping_Eintragstyp_und_ProfessionOID automatisch eingetragen. Siehe auch [gemSpecOID]# Tab_PKI_402 und Tab_PKI_403")
    public String getEntryType() {
        return this.entryType;
    }

    public UserCertificate telematikID(String telematikID) {
        this.telematikID = telematikID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Wird beim Anlegen des Eintrags vom VZD aus dem Zertifikat \u00c3\u00bcbernommen (Feld registrationNumber der Extension Admission). Falls der Basiseintrag (baseDirectoryEntry) ohne Zertifikat angelegt wird, kann in Operation add_Directory_Entry die telematikID angegeben werden. Damit ist der Verzeichniseintrag bereits \u00c3\u00bcber die telematikID auffindbar.")
    public String getTelematikID() {
        return this.telematikID;
    }

    public void setTelematikID(String telematikID) {
        this.telematikID = telematikID;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getProfessionOID() {
        return this.professionOID;
    }

    public UserCertificate usage(List<UsageEnum> usage) {
        this.usage = usage;
        return this;
    }

    public UserCertificate addUsageItem(UsageEnum usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageEnum>();
        }
        this.usage.add(usageItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Nutzungskennzeichnung kann pro Zertifikat mehrfach vergeben werden. Vorgegebener Wertebereich [KOM-LE, ePA]. Obligatorisch f\u00c3\u00bcr LEI und KTR mit vorgegebenem Wert usage=ePA")
    public List<UsageEnum> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageEnum> usage) {
        this.usage = usage;
    }

    public UserCertificate userCertificate(String userCertificate) {
        this.userCertificate = userCertificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Zertifikat im DER Format. Base64 kodiert. Die pflegende Stelle erh\u00c3\u00a4lt das Zertifikat vom TSP oder falls das nicht m\u00c3\u00b6glich ist wird ein Ersatzverfahren abgestimmt.")
    public String getUserCertificate() {
        return this.userCertificate;
    }

    public void setUserCertificate(String userCertificate) {
        this.userCertificate = userCertificate;
    }

    public UserCertificate description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dieses Attribut erm\u00c3\u00b6glicht das Zertifikat zu beschreiben, um die Administration des VZD Eintrags zu vereinfachen.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCertificate userCertificate = (UserCertificate)o;
        return Objects.equals(this.dn, userCertificate.dn) && Objects.equals(this.entryType, userCertificate.entryType) && Objects.equals(this.telematikID, userCertificate.telematikID) && Objects.equals(this.professionOID, userCertificate.professionOID) && Objects.equals(this.usage, userCertificate.usage) && Objects.equals(this.userCertificate, userCertificate.userCertificate) && Objects.equals(this.description, userCertificate.description);
    }

    public int hashCode() {
        return Objects.hash(this.dn, this.entryType, this.telematikID, this.professionOID, this.usage, this.userCertificate, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCertificate {\n");
        sb.append("    dn: ").append(this.toIndentedString(this.dn)).append("\n");
        sb.append("    entryType: ").append(this.toIndentedString(this.entryType)).append("\n");
        sb.append("    telematikID: ").append(this.toIndentedString(this.telematikID)).append("\n");
        sb.append("    professionOID: ").append(this.toIndentedString(this.professionOID)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    userCertificate: ").append(this.toIndentedString(this.userCertificate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UsageEnum {
        KOM_LE("KOM-LE"),
        EPA("ePA");

        private String value;

        private UsageEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UsageEnum fromValue(String value) {
            for (UsageEnum b : UsageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<UsageEnum> {
            @Override
            public void write(JsonWriter jsonWriter, UsageEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public UsageEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UsageEnum.fromValue(value);
            }
        }
    }
}

