/*
 * Copyright (c) 2020 gematik GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * I_Directory_Administration
 * REST Schnittstelle zur Pflege der Verzeichniseinträge. Über diese Schnittstelle können Verzeichniseinträge inklusive Zertifikaten erzeugt, aktualisiert und gelöscht werden. Die Administration von Fachdaten erfolgt über Schnittstelle I_Directory_Application_Maintenance und wird durch die Fachanwendungen durchgeführt. Lesender Zugriff auf die Fachdaten ist mit Operation getDirectoryEntries in vorliegender Schnittstelle möglich.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package de.gematik.ti.epa.vzd.client.api;

import de.gematik.ti.epa.vzd.client.invoker.ApiException;
import de.gematik.ti.epa.vzd.client.model.BaseDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.CreateDirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.DirectoryEntry;
import de.gematik.ti.epa.vzd.client.model.DistinguishedName;
import de.gematik.ti.epa.vzd.client.model.Error;
import org.junit.Test;
import org.junit.Ignore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * API tests for DirectoryEntryAdministrationApi
 */
@Ignore
public class DirectoryEntryAdministrationApiTest {

    private final DirectoryEntryAdministrationApi api = new DirectoryEntryAdministrationApi();

    
    /**
     * Einen Eintrag zum Verzeichnisdienst hinzufügen
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void addDirectoryEntryTest() throws ApiException {
        CreateDirectoryEntry createDirectoryEntry = null;
        DistinguishedName response = api.addDirectoryEntry(createDirectoryEntry);

        // TODO: test validations
    }
    
    /**
     * Gesamten Verzeichniseintrag löschen
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void deleteDirectoryEntryTest() throws ApiException {
        String uid = null;
        api.deleteDirectoryEntry(uid);

        // TODO: test validations
    }
    
    /**
     * Der Verzeichniseintrag (ohne Zertifikate und Fachdaten) wird mit den übergebenen Daten aktualisiert.
     *
     * 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void modifyDirectoryEntryTest() throws ApiException {
        String uid = null;
        BaseDirectoryEntry baseDirectoryEntry = null;
        DistinguishedName response = api.modifyDirectoryEntry(uid, baseDirectoryEntry);

        // TODO: test validations
    }
    
    /**
     * Gesamten Verzeichniseintrag lesen
     *
     * Liefert alle zum Filter passenden Verzeichniseinträge. Die angegebenen Parameter werden mit logischen UND verknüpft.
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void readDirectoryEntryTest() throws ApiException {
        String uid = null;
        String givenName = null;
        String sn = null;
        String cn = null;
        String displayName = null;
        String streetAddress = null;
        String postalCode = null;
        String localityName = null;
        String stateOrProvienceName = null;
        String title = null;
        String organization = null;
        String otherName = null;
        String specialization = null;
        String domainID = null;
        String personalEntry = null;
        String dataFromAuthority = null;
        List<DirectoryEntry> response = api.readDirectoryEntry(uid, givenName, sn, cn, displayName, streetAddress, postalCode, localityName, stateOrProvienceName, title, organization, otherName, specialization, domainID, personalEntry, dataFromAuthority);

        // TODO: test validations
    }
    
}
